/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import org.maachang.leveldb.JniIO;
import org.maachang.leveldb.jni;

final class SnappyCore {
    protected SnappyCore() {
    }

    public static final int calcMaxCompressLength(int len) {
        return 32 + len + len / 6;
    }

    public static int decompressLength(long address, int off, int len) {
        int i = 0;
        int ret = 0;
        do {
            ret += (JniIO.get(address, off) & 0x7F) << i++ * 7;
        } while ((JniIO.get(address, off++) & 0x80) == 128);
        return ret;
    }

    public static int compress(long src, int src_len, long dest) {
        int[] ret = new int[1];
        jni.snappyCompress(src, src_len, dest, ret);
        return ret[0];
    }

    public static int compress(int[] out, long src, int src_len, long dest) {
        jni.snappyCompress(src, src_len, dest, out);
        return out[0];
    }

    public static int decompress(long src, int src_len, long dst) {
        int[] ret = new int[1];
        if (jni.snappyDecompress(src, src_len, dst, ret) >= 0) {
            return ret[0];
        }
        return -1;
    }

    public static void decompress(int[] out, long src, int src_len, long dst) {
        if ((out == null || out.length > 0) && jni.snappyDecompress(src, src_len, dst, out) < 0) {
            out[0] = -1;
        }
    }
}

