/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.maachang.leveldb.JniBuffer;
import org.maachang.leveldb.Leveldb;
import org.maachang.leveldb.LeveldbException;
import org.maachang.leveldb.LeveldbIterator;
import org.maachang.leveldb.ValueBinary;
import org.maachang.leveldb.WriteBatchMap;

public class LevelMap
implements Map<String, Object> {
    protected static final ThreadLocal<JniBuffer> keyBuffer = new ThreadLocal();
    protected static final ThreadLocal<JniBuffer> valueBuffer = new ThreadLocal();
    protected Leveldb leveldb;
    protected LevelMapSet set;

    public LevelMap(String name) throws Exception {
        this(name, -1, -1, -1, -1);
    }

    public LevelMap(String name, int write_buffer_size, int max_open_files, int block_size, int block_restart_interval) throws Exception {
        this.leveldb = new Leveldb(name, write_buffer_size, max_open_files, block_size, block_restart_interval);
        this.set = new LevelMapSet(this);
    }

    protected final void finalize() throws Exception {
        this.close();
    }

    public final void close() {
        this.leveldb.close();
    }

    public final Leveldb getLevedb() {
        return this.leveldb;
    }

    public final WriteBatchMap writeBatch() {
        return new WriteBatchMap(this);
    }

    public static final JniBuffer getKeyBuffer() throws Exception {
        return LevelMap.getKeyBuffer(null);
    }

    public static final JniBuffer getKeyBuffer(String name) throws Exception {
        JniBuffer ret = keyBuffer.get();
        if (ret == null) {
            ret = new JniBuffer();
            keyBuffer.set(ret);
        }
        if (name != null) {
            ret.setString(name);
        }
        return ret;
    }

    public static final JniBuffer getValueBuffer() throws Exception {
        return LevelMap.getValueBuffer(null);
    }

    public static final JniBuffer getValueBuffer(Object value) throws Exception {
        JniBuffer ret = valueBuffer.get();
        if (ret == null) {
            ret = new JniBuffer();
            valueBuffer.set(ret);
        }
        if (value != null) {
            ValueBinary.encode(ret, value);
        }
        return ret;
    }

    public final void clearCache() {
        JniBuffer v = keyBuffer.get();
        if (v != null) {
            keyBuffer.remove();
            v.destroy();
        }
        if ((v = valueBuffer.get()) != null) {
            valueBuffer.remove();
            v.destroy();
        }
    }

    @Override
    public final void clear() {
        try {
            LeveldbIterator it = this.leveldb.iterator();
            JniBuffer key = LevelMap.getKeyBuffer(null);
            while (it.valid()) {
                if (it.key(key) > 0) {
                    this.leveldb.remove(key);
                }
                it.next();
            }
        }
        catch (LeveldbException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LeveldbException(e);
        }
    }

    @Override
    public final void putAll(Map toMerge) {
        for (Object k : toMerge.keySet()) {
            if (!(k instanceof String)) continue;
            this.put((String)k, toMerge.get(k));
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public final boolean containsValue(Object value) {
        try {
            it = this.leveldb.iterator();
            v = LevelMap.getValueBuffer(null);
            if (value == null) {
                while (true) {
                    if (!it.valid()) {
                        return false;
                    }
                    if (it.value(v) > 0 && ValueBinary.decode(v) == null) {
                        return true;
                    }
                    it.next();
                }
            }
            ** GOTO lbl20
        }
        catch (LeveldbException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LeveldbException(e);
        }
lbl-1000:
        // 1 sources

        {
            if (it.value(v) > 0 && value.equals(ValueBinary.decode(v))) {
                return true;
            }
            it.next();
lbl20:
            // 2 sources

            ** while (it.valid())
        }
lbl21:
        // 1 sources

        return false;
    }

    @Override
    public Set entrySet() {
        throw new LeveldbException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public Collection values() {
        throw new LeveldbException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    @Override
    public final Object put(String name, Object value) {
        if (name == null) {
            return null;
        }
        if (value != null && value instanceof LevelMap) {
            throw new LeveldbException("\u8981\u7d20\u306bLevelMap\u8981\u7d20\u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        try {
            JniBuffer keyBuf = LevelMap.getKeyBuffer(name);
            JniBuffer valBuf = LevelMap.getValueBuffer(value);
            this.leveldb.put(keyBuf, valBuf);
            keyBuf.clear();
            valBuf.clear();
            return null;
        }
        catch (LeveldbException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LeveldbException(e);
        }
    }

    @Override
    public final boolean containsKey(Object key) {
        if (key == null) {
            return false;
        }
        try {
            JniBuffer keyBuf = LevelMap.getKeyBuffer((String)key);
            JniBuffer valBuf = LevelMap.getValueBuffer(null);
            int res = this.leveldb.get(valBuf, keyBuf);
            keyBuf.clear();
            valBuf.clear();
            return res != 0;
        }
        catch (LeveldbException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LeveldbException(e);
        }
    }

    @Override
    public final Object get(Object key) {
        JniBuffer valBuf;
        JniBuffer keyBuf;
        block5: {
            if (key == null) {
                return null;
            }
            keyBuf = LevelMap.getKeyBuffer((String)key);
            valBuf = LevelMap.getValueBuffer(null);
            int res = this.leveldb.get(valBuf, keyBuf);
            if (res != 0) break block5;
            return null;
        }
        try {
            Object ret = ValueBinary.decode(valBuf);
            keyBuf.clear();
            valBuf.clear();
            return ret;
        }
        catch (LeveldbException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LeveldbException(e);
        }
    }

    @Override
    public final Object remove(Object key) {
        if (key == null) {
            return false;
        }
        try {
            JniBuffer keyBuf = LevelMap.getKeyBuffer((String)key);
            Boolean ret = this.leveldb.remove(keyBuf);
            keyBuf.clear();
            return ret;
        }
        catch (LeveldbException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LeveldbException(e);
        }
    }

    @Override
    public final boolean isEmpty() {
        LeveldbIterator it;
        block4: {
            it = this.leveldb.iterator();
            if (!it.valid()) break block4;
            it.close();
            return false;
        }
        try {
            it.close();
            return true;
        }
        catch (LeveldbException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LeveldbException(e);
        }
    }

    @Override
    public final Set keySet() {
        return this.set;
    }

    @Override
    public final int size() {
        try {
            int ret = 0;
            LeveldbIterator it = this.leveldb.iterator();
            while (it.valid()) {
                ++ret;
                it.next();
            }
            it.close();
            return ret;
        }
        catch (LeveldbException le) {
            throw le;
        }
        catch (Exception e) {
            throw new LeveldbException(e);
        }
    }

    public final void getAllKey(Set<Object> set) {
        throw new LeveldbException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public final void getAllValues(Set<Object> set) {
        throw new LeveldbException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }

    public final String toString() {
        return "";
    }

    private static final class LevelMapIterator
    implements Iterator<String> {
        private final LevelMap map;
        private final LeveldbIterator itr;
        private String nowKey;

        public LevelMapIterator(LevelMap map) {
            this.map = map;
            this.itr = map.leveldb.iterator();
        }

        @Override
        public final boolean hasNext() {
            if (!this.itr.valid()) {
                this.nowKey = null;
                return false;
            }
            return true;
        }

        @Override
        public final String next() {
            try {
                JniBuffer buf = LevelMap.getKeyBuffer(null);
                this.nowKey = this.itr.key(buf) <= 0 ? null : buf.getString();
                buf.clear();
                this.itr.next();
                return this.nowKey;
            }
            catch (LeveldbException le) {
                throw le;
            }
            catch (Exception e) {
                throw new LeveldbException(e);
            }
        }

        @Override
        public final void remove() {
            if (this.nowKey != null) {
                this.map.remove(this.nowKey);
            }
        }
    }

    private static final class LevelMapSet
    implements Set<String> {
        private final LevelMap map;

        public LevelMapSet(LevelMap map) {
            this.map = map;
        }

        @Override
        public final boolean add(String arg0) {
            this.map.put(arg0, (Object)null);
            return false;
        }

        @Override
        public final boolean addAll(Collection<? extends String> arg0) {
            for (String string : arg0) {
                if (!(string instanceof String)) continue;
                this.add(string);
            }
            return true;
        }

        @Override
        public final void clear() {
            this.map.clear();
        }

        @Override
        public final boolean contains(Object arg0) {
            return this.map.containsKey(arg0);
        }

        @Override
        public final boolean containsAll(Collection<?> arg0) {
            for (Object o : arg0) {
                if (o instanceof String && this.map.containsKey(o)) continue;
                return false;
            }
            return true;
        }

        @Override
        public final boolean isEmpty() {
            return this.map.isEmpty();
        }

        @Override
        public final Iterator<String> iterator() {
            return new LevelMapIterator(this.map);
        }

        @Override
        public final boolean remove(Object arg0) {
            return (Boolean)this.map.remove(arg0);
        }

        @Override
        public final boolean removeAll(Collection<?> arg0) {
            boolean ret = false;
            for (Object o : arg0) {
                if (!(o instanceof String) || !((Boolean)this.map.remove(o)).booleanValue()) continue;
                ret = true;
            }
            return ret;
        }

        @Override
        public final boolean retainAll(Collection<?> arg0) {
            throw new LeveldbException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }

        @Override
        public final int size() {
            return this.map.size();
        }

        @Override
        public final Object[] toArray() {
            throw new LeveldbException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }

        @Override
        public final <T> T[] toArray(T[] arg0) {
            throw new LeveldbException("\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
    }
}

