package org.maachang.rimdb.util ;

/**
 * 数字KeyオブジェクトValue子要素.
 * 
 * @version 2014/07/21
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class NOChild<T> {
    public T o ;
    protected int b ;
    protected NOChild<T> n ;
    
    /**
     * コンストラクタ.
     * @param k 対象のキーを設定します.
     * @param v 対象の要素を設定します.
     */
    protected NOChild( int k,T v ) {
        b = k ; o = v ;
    }
    
    /**
     * 対象のキーを取得.
     * @return int 対象のキーコードが返却されます.
     */
    public final int getKey() {
        return b ;
    }
    
    /**
     * 対象の要素を取得.
     * @return T 対象の要素が返却されます.
     */
    public final T getValue() {
        return o ;
    }
    
    /**
     * 対象の要素を変更.
     * @param v 要素を設定します.
     */
    public final void setValue( final T v ) {
        o = v ;
    }
    
}
