package org.maachang.rimdb.table ;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.util.NSet;

/**
 * テーブルユーティリティ.
 * 
 * @version 2014/07/10
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class TableUtil {
    
    /** 小文字大文字差分. **/
    private static final int _Aa = (int)'a' - (int)'A' ;
    
    /**
     * Java用データ名をDB用データ名に変換.
     * @param name 対象の名前を設定します.
     * @return String DB用の名前が返却されます.
     */
    public static final String convertJavaNameByDBName(String name) {
        char c = name.charAt(0) ;
        int len = name.length();
        StringBuilder buf = new StringBuilder( len << 1 );
        if( c >= 'A' && c <= 'Z' ) {
            buf.append( (char)(c+_Aa) ) ;
        }
        else {
            buf.append(c);
        }
        for (int i = 1; i < len; i++) {
            if ((c = name.charAt(i)) >= 'A' && c <= 'Z') {
                buf.append("_").append((char)(c+_Aa)) ;
            }
            else {
                buf.append(c);
            }
        }
        return buf.toString() ;
    }
    
    /**
     * DB用データ名をJava用データ名に変換.
     * @param table テーブル名の変換の場合は[true]を設定します.
     * @param name 対象の名前を設定します.
     * @return String Java用の名前が返却されます.
     */
    public static final String convertDBNameByJavaName(boolean table,String name) {
        char cp ;
        char c = name.charAt(0) ;
        int len = name.length();
        StringBuilder buf = new StringBuilder( len );
        if( table && c >= 'a' && c <= 'z' ) {
            buf.append( (char)(c - _Aa) ) ;
        }
        else {
            buf.append(c);
        }
        for (int i = 1; i < len; i++) {
            if ((c = name.charAt(i)) == '_') {
                if (i + 1 < len && ((cp = name.charAt(i + 1)) >= 'a' && cp <= 'z' ) ) {
                    buf.append((char) ('A' + (cp - 'a')));
                    i++;
                }
            }
            else {
                buf.append(c);
            }
        }
        return buf.toString() ;
    }
    
    /** ヘッダカラムに対する、定義カラムの項番を取得. **/
    protected static final int[] headerColumnByNoList( final String[] columns,final String[] targetColumns ) {
        int i,j ;
        final int len = columns.length ;
        final int headerLen = targetColumns.length ;
        final int[] ret = new int[ headerLen ] ;
        String n ;
        for( i = 0 ; i < headerLen ; i ++ ) {
            ret[ i ] = -1 ;
            n = targetColumns[ i ] ;
            for( j = 0 ; j < len ; j ++ ) {
                if( columns[ j ].equals( n ) ) {
                    ret[ i ] = j ;
                    break ;
                }
            }
        }
        
        // カラム情報のチェック処理.
        NSet set = new NSet() ;
        for( i = 0 ; i < headerLen ; i ++ ) {
            if( ret[ i ] == -1 ) {
                //throw new RimDbException( "対象カラム名[" + targetColumns[ i ] + "]は、存在しないカラム名です" ) ;
                
                // 登録されていないカラム名がセットされている場合は無視する.
                continue ;
            }
            if( set.contains( ret[ i ] ) ) {
                throw new RimDbException( "対象カラム名[" + targetColumns[ i ] + "]は重複しています" ) ;
            }
            set.add( ret[ i ] ) ;
        }
        
        return ret ;
    }
    
}
