package org.maachang.rimdb.table ;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/**
 * テーブル管理オブジェクト.
 * 
 * @version 2014/07/11
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class TableManager {
    
    /** テーブル管理Map. **/
    private final Map<String,TableImpl> map = new ConcurrentHashMap<String,TableImpl>() ;
    
    /**
     * コンストラクタ.
     */
    public TableManager() {
    }
    
    /**
     * テーブル利用後のリセット.
     * この処理は、Rowデータなど、アクセスが終了した後に呼び出す必要があります.
     */
    public final void reset() {
        Iterator<String> it = map.keySet().iterator() ;
        while( it.hasNext() ) {
            map.get( it.next() ).row.clear() ;
        }
    }
    
    /**
     * テーブル設定.
     * @param table 対象のテーブルオブジェクトを設定します.
     */
    public final void set( final TableImpl table ) {
        map.put( table.getName(),table ) ;
    }
    
    /**
     * テーブル取得.
     * @param name 対象のテーブル名を設定します.
     * @return Table 対象のテーブル情報が返却されます.
     */
    public final TableImpl get( final String name ) {
        return map.get( TableUtil.convertJavaNameByDBName( name ) ) ;
    }
    
    /**
     * 登録テーブル数を取得.
     * @return int 登録されているテーブル数が返却されます.
     */
    public final int size() {
        return map.size() ;
    }
    
    /**
     * 登録テーブル名一覧を取得.
     * @return String[] 登録されているテーブル名一覧が返却されます.
     */
    public final String[] getNames() {
        int cnt = 0 ;
        String[] ret = new String[ map.size() ] ;
        Iterator<String> it = map.keySet().iterator() ;
        while( it.hasNext() ) {
            ret[ cnt ++ ] = it.next() ;
        }
        Arrays.sort( ret ) ;
        return ret ;
    }
}
