package org.maachang.rimdb.table ;

/**
 * テーブル読み込みオブジェクト.
 * 
 * @version 2014/07/10
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public abstract class LoadTable {
    
    /** テーブル作成オブジェクト. **/
    protected CreateTable createTable ;
    
    /**
     * テーブル定義.
     * @param name テーブル名を設定します.
     * @param names カラム名群を設定します.
     * @param types カラムタイプ群を設定します.
     * @param uniqueNames ユニーク定義カラム名群を設定します.
     * @param indexNames インデックス定義カラム名群を設定します.
     * @param ngramNames NGramインデックス作成カラム名群を設定します.
     * @param posX 空間インデックス名のX軸カラム名を設定します.
     * @param posY 空間インデックス名のY軸カラム名を設定します.
     * @param accuracy 空間インデックス精度を設定します.
     */
    public void define( String name,String[] names,int[] types,
        String[] uniqueNames,String[] indexNames,String[] ngramNames,
        String positionX,String positionY,int accuracy ) {
        
        // Java名をテーブル名に強制変換.
        int i,len ;
        name = TableUtil.convertJavaNameByDBName( name ) ;
        len = names.length ;
        for( i = 0 ; i < len ; i ++ ) {
            names[ i ] = TableUtil.convertJavaNameByDBName( names[ i ] ) ;
        }
        if( uniqueNames != null ) {
            len = uniqueNames.length ;
            for( i = 0 ; i < len ; i ++ ) {
                uniqueNames[ i ] = TableUtil.convertJavaNameByDBName( uniqueNames[ i ] ) ;
            }
        }
        if( indexNames != null ) {
            len = indexNames.length ;
            for( i = 0 ; i < len ; i ++ ) {
                indexNames[ i ] = TableUtil.convertJavaNameByDBName( indexNames[ i ] ) ;
            }
        }
        if( positionX != null ) {
            positionX = TableUtil.convertJavaNameByDBName( positionX ) ;
        }
        if( positionY != null ) {
            positionY = TableUtil.convertJavaNameByDBName( positionY ) ;
        }
        
        // テーブル作成.
        createTable = new CreateTable( name,names,types,uniqueNames,indexNames,
        	ngramNames,positionX,positionY,accuracy ) ;
    }
    
    /**
     * テーブル作成.
     * @return Table 新しいテーブルオブジェクトが返却されます.
     */
    public abstract TableImpl create() ;
    
}

