package org.maachang.rimdb.table ;

/**
 * カラム名情報.
 * 
 * @version 2014/07/07
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
@SuppressWarnings("unchecked")
public final class ColumnName implements Comparable {
    
    protected final String name ;
    protected final int no ;
    
    /**
     * コンストラクタ.
     * @param name 対象のカラム名を設定します.
     * @param no 対象の項番を設定します.
     */
    public ColumnName( String name,int no ) {
        this.name = name ;
        this.no = no ;
    }
    
    /**
     * 比較処理.
     * @param o 対象のオブジェクトを設定します.
     * @return int 比較結果が返却されます.
     */
    public final int compareTo( final Object o ) {
        if( o instanceof String ) {
            return name.compareTo( (String)o ) ;
        }
        return name.compareTo( ((ColumnName)o).name ) ;
    }
    
    /**
     * 対象のカラム名を取得.
     * @return String カラム名が返却されます.
     */
    public final String getName() {
        return name ;
    }
    
    /**
     * 対象の項番を取得.
     * @return int 項番が返却されます.
     */
    public final int getNo() {
        return no ;
    }
}
