package org.maachang.rimdb.search ;

import org.maachang.rimdb.index.Pointer;
import org.maachang.rimdb.index.SearchPointer;
import org.maachang.rimdb.util.OList;

/**
 * 検索ポインターリスト.
 * 
 * @version 2014/07/13
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
@SuppressWarnings("unchecked")
public final class PointerList implements Block<SearchPointer[]> {
    protected PointerList(){}
    
    /** 検索ポインタリスト. **/
    private SearchPointer[] list ;
    
    /** ブロックタイプ. **/
    private int type ;
    
    /**
     * コンストラクタ.
     * @param t 対象の検索タイプを設定します.
     * @param o 対象の検索ポインタリストを設定します.
     */
    protected PointerList( int t,OList<Pointer> o ) {
        final int len = o.size() ;
        SearchPointer[] n = new SearchPointer[ len ] ;
        System.arraycopy( o.toArray(),0,n,0,len ) ;
        list = n ;
        type = t ;
    }
    
    /**
     * コンストラクタ.
     * @param t 対象の検索タイプを設定します.
     * @param o 対象の検索ポインタリストを設定します.
     */
    protected PointerList( int t,SearchPointer[] o ) {
        list = o ;
        type = t ;
    }
    
    /**
     * ブロックタイプを取得.
     * @return int ブロックタイプが返却されます.
     */
    public final int getType() {
        return type ;
    }
    
    /**
     * 検索ポインタリストを取得.
     * @return SearchPointer[] 検索ポインタリストが返却されます.
     */
    public final SearchPointer[] get() {
        return list ;
    }
    
    /**
     * 文字情報表示.
     * @return String 文字情報を表示します.
     */
    public final String toString() {
        StringBuilder buf = new StringBuilder( " [Pointer-List]:[" ).
            append( type ).append( "] " ) ;
        int len = list.length ;
        for( int i = 0 ; i < len ; i ++ ) {
            buf.append( " " ).append( list[ i ] ) ;
        }
        return buf.toString() ;
    }
}
