package org.maachang.rimdb.index.string ;

import org.maachang.rimdb.index.IfPointer;

/**
 * String(IString)一致,不一致ポインタ.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class StringEq extends IfPointer<IString> {
    protected StringEq(){}
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param eq 一致条件で処理する場合は[true]を設定,
     *           不一致で処理する場合は[false]を設定します.
     */
    public StringEq( StringIndex index,boolean eq ) {
        if( eq ) {
            this.type = TYPE_EQ ;
        }
        else {
            this.type = TYPE_NEQ ;
        }
        this.columnName = index.getColumnName() ;
        this.eq = eq ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param eq 一致条件で処理する場合は[true]を設定,
     *           不一致で処理する場合は[false]を設定します.
     * @param word 対象の検索ワードを設定します.
     */
    public StringEq( StringIndex index,boolean eq,IString word ) {
        this( index,eq ) ;
        set( word ) ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param eq 一致条件で処理する場合は[true]を設定,
     *           不一致で処理する場合は[false]を設定します.
     * @param word 対象の検索ワードを設定します.
     */
    public StringEq( StringIndex index,boolean eq,String word ) {
        this( index,eq ) ;
        set( new IString( word ) ) ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param eq 一致条件で処理する場合は[true]を設定,
     *           不一致で処理する場合は[false]を設定します.
     * @param word 対象の検索ワードを設定します.
     */
    public StringEq( StringIndex index,boolean eq,Object word ) {
        this( index,eq ) ;
        parameter( word ) ;
    }
    
    /**
     * 情報セット.
     * @param word 対象の検索ワードを設定します.
     */
    public final void parameter( final Object word ) {
        set( StringIn.convert( word ) ) ;
    }
    
    /**
     * オブジェクトコピー.
     * @param mode [true]を設定した場合、パラメータ情報はコピーされません.
     * @return SearchPointer コピーされたオブジェクトが返却されます.
     */
    public final StringEq copy( final boolean mode ) {
        StringEq ret = new StringEq() ;
        baseCopy( mode,ret ) ;
        return ret ;
    }
}
