package org.maachang.rimdb.index.string ;

import org.maachang.rimdb.index.CreateIndex;
import org.maachang.rimdb.util.OList;

/**
 * Stringインデックス作成オブジェクト
 * 
 * @version 2014/07/04
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class CreateStringIndex extends CreateIndex<String,StringIndex> {
    
    /**
     * コンストラクタ.
     */
    public CreateStringIndex() {
        list = new OList<String>() ;
    }
    
    /**
     * インデックス行情報をセット.
     * @param array インデックスに追加する配列オブジェクトを設定します.
     */
    public void addArray( String[] array ) {
        if( list.size() == 0 ) {
            list.setAll( array ) ;
        }
        else {
            final int len = array.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                list.add( array[ i ]  ) ;
            }
        }
    }
    
    /**
     * 配列生成.
     * @param length 配列生成サイズを設定します.
     * @return Object 生成された配列が返却されます.
     */
    protected final Object create( final int length ) {
        return new IString[ length ] ;
    }
    
    /**
     * 配列セット.
     * @param index 対象のインデックスを設定します.
     * @param no 対象の項番を設定します.
     * @param value 対象の条件を設定します.
     */
    protected final void set( final Object index,final int no,final Object value ) {
        ((IString[])index)[ no ] = new IString( (String)value ) ;
    }
    
    /**
     * インデックス変換.
     * @param index 対象のインデックスを設定します.
     * @param lines 対象の行インデックスを設定します.
     * @param max 全件数を設定します.
     * @return StringIndex 生成されたインデックスオブジェクトが返却されます.
     */
    protected final StringIndex convert( final Object index,final int[][] lines,final int max ) {
        return convert( index,false,lines,max ) ;
    }
    
    /**
     * インデックス変換.
     * @param index 対象のインデックスを設定します.
     * @param ngram Like検索用のNGramを有効にする場合は[true]を設定します.
     * @param lines 対象の行インデックスを設定します.
     * @param max 全件数を設定します.
     * @return StringIndex 生成されたインデックスオブジェクトが返却されます.
     */
    protected final StringIndex convert( final Object index,final boolean ngram,
        final int[][] lines,final int max ) {
        if( ngram ) {
            return new StringIndex( (IString[])index,
                NGram.createIndex( (IString[])index ),lines,max ) ;
        }
        else {
            return new StringIndex( (IString[])index,null,lines,max ) ;
        }
    }
    
}
