package org.maachang.rimdb.index.numberFloat ;

import org.maachang.rimdb.index.CreateIndex;
import org.maachang.rimdb.util.OList;

/**
 * Floatインデックス作成オブジェクト
 * 
 * @version 2014/07/04
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class CreateNumberFloatIndex extends CreateIndex<Double,NumberFloatIndex> {
    
    /**
     * コンストラクタ.
     */
    public CreateNumberFloatIndex() {
        list = new OList<Double>() ;
    }
    
    /**
     * インデックス行情報をセット.
     * @param array インデックスに追加する配列オブジェクトを設定します.
     */
    public void addArray( Double[] array ) {
        if( list.size() == 0 ) {
            list.setAll( array ) ;
        }
        else {
            final int len = array.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                list.add( array[ i ]  ) ;
            }
        }
    }
    
    /**
     * インデックス行情報をセット.
     * @param array インデックスに追加する配列オブジェクトを設定します.
     */
    public void addArray( double[] array ) {
        if( list.size() == 0 ) {
            list.setAll( array ) ;
        }
        else {
            final int len = array.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                list.add( array[ i ]  ) ;
            }
        }
    }
    
    /**
     * 配列生成.
     * @param length 配列生成サイズを設定します.
     * @return Object 生成された配列が返却されます.
     */
    protected final Object create( final int length ) {
        return new double[ length ] ;
    }
    
    /**
     * 配列セット.
     * @param index 対象のインデックスを設定します.
     * @param no 対象の項番を設定します.
     * @param value 対象の条件を設定します.
     */
    protected final void set( final Object index,final int no,final Object value ) {
        ((double[])index)[ no ] = (Double)value ;
    }
    
    /**
     * インデックス変換.
     * @param index 対象のインデックスを設定します.
     * @param lines 対象の行インデックスを設定します.
     * @param max 全件数を設定します.
     * @return NumberFloatIndex 生成されたインデックスオブジェクトが返却されます.
     */
    protected final NumberFloatIndex convert( final Object index,final int[][] lines,final int max ) {
        return new NumberFloatIndex( (double[])index,lines,max ) ;
    }
    
}
