package org.maachang.rimdb.index ;

import org.maachang.rimdb.table.Indexs;
import org.maachang.rimdb.util.NAdd;


/**
 * 検索ポインタ.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
@SuppressWarnings("unchecked")
public abstract class SearchPointer<T> implements Pointer,Comparable<SearchPointer<T>> {
    
    /** 検索種別. **/
    protected int type ;
    
    /** カラム名. **/
    protected String columnName ;
    
    /** インデックス件数. **/
    protected int length ;
    
    /** 行数. **/
    protected int count ;
    
    /** リセットフラグ. **/
    protected boolean resetFlag ;
    
    /** カラム番号. **/
    protected int no = -1 ;
    
    /**
     * 情報リセット.
     * @param mode [true]を設定した場合、設定ワード条件も削除します.
     */
    public void reset( boolean mode ) {
        if( mode == true ) {
            resetFlag = true ;
        }
        length = 0 ;
        count = 0 ;
    }
    
    /**
     * カラム名を取得.
     * @return String カラム名が返却されます.
     */
    public final String getColumnName() {
        return columnName ;
    }
    
    /**
     * 番号取得.
     * @return int 番号が返却されます.
     */
    public final int getNo() {
        return no ;
    }
    
    /**
     * 番号設定.
     * @param no 対象の番号を設定します.
     */
    public final void setNo( final int no ) {
        this.no = no ;
    }
    
    /**
     * 処理タイプを取得.
     * @return int 処理タイプが返却されます[TYPE_XXXX].
     */
    public final int getType() {
        return type ;
    }
    
    /**
     * インデックス件数を取得.
     * @return int インデックス件数が返却されます.
     */
    public final int getLength() {
        return length ;
    }
    
    /**
     * 行件数を取得.
     * @return int 行件数が返却されます.
     */
    public final int getCount() {
        return count ;
    }
    
    /**
     * 比較処理.
     * @param n 対象のオブジェクトが設定されます.
     * @return int 比較結果が返却されます.
     */
    public final int compareTo( final SearchPointer<T> n ) {
        if( count > n.count ) {
            return 1 ;
        }
        else if( count < n.count ) {
            return -1 ;
        }
        return 0 ;
    }
    
    /** ベースコピー. **/
    protected void baseCopy( boolean mode,SearchPointer o ) {
        o.type = type ;
        o.columnName = columnName ;
        o.length = 0 ;
        o.count = 0 ;
        if( mode ) {
            o.resetFlag = true ;
        }
        o.no = no ;
    }
    
    /**
     * 情報セット.
     * @param word 対象の情報を設定します.
     */
    public abstract void parameter( Object word ) ;
    
    /**
     * 検索処理.
     * @param index 対象のインデックスを設定します.
     */
    public abstract void search( T index ) ;
    
    /**
     * 検索処理.
     * @param indexTable 対象のインデックステーブルを設定します.
     */
    public final void search( final Indexs indexTable ) {
        search( (T)indexTable.getIndex( columnName ) ) ;
    }
    
    /**
     * 検索結果情報をNAdd情報に格納.
     * ※この処理は、検索条件が１件の場合に利用します.
     * @param out 検索結果の行情報をNAdd情報にセットします.
     * @param index 対象のインデックスを設定します.
     */
    public abstract void get( NAdd out,T index ) ;
    
    /**
     * 検索結果情報をNAdd情報に格納.
     * ※この処理は、検索条件が１件の場合に利用します.
     * @param out 検索結果の行情報をNAdd情報にセットします.
     * @param indexTable 対象のインデックステーブルを設定します.
     */
    public final void get( NAdd out,final Indexs indexTable ) {
        get( out,(T)indexTable.getIndex( columnName ) ) ;
    }
    
    /**
     * オブジェクトコピー.
     * @param mode [true]を設定した場合、パラメータ情報はコピーされません.
     * @return SearchPointer コピーされたオブジェクトが返却されます.
     */
    public abstract SearchPointer<T> copy( boolean mode ) ;
}
