package org.maachang.rimdb ;

import java.util.List;


/**
 * 検索処理.
 * 
 * @version 2014/07/11
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
@SuppressWarnings("unchecked")
public interface Search {
    
    /**
     * 情報クリア.
     */
    public void clear() ;
    
    /**
     * テーブル名を取得.
     * @return String テーブル名が返却されます.
     */
    public String getName() ;
    
    /**
     * パラメータ数を取得.
     * @return int パラメータ数が返却されます.
     */
    public int getParameterSize() ;
    
    /**
     * 情報設定.
     * @param no 対象の項番を設定します.
     * @param value 対象のパラメータを設定します.
     * @return Search オブジェクトが返却されます.
     */
    public Search setParameter( int no,Object... value ) ;
    
    /**
     * パラメータ群をセット.
     * @param values 対象のパラメータ群を設定します.
     * @return Search オブジェクトが返却されます.
     * @version rimdb-1.01
     */
    public Search setParameters( List values ) ;
    
    /**
     * パラメータ群をセット.
     * @param values 対象のパラメータ群を設定します.
     * @return Search オブジェクトが返却されます.
     * @version rimdb-1.01
     */
    public Search setParameters( Object... values ) ;
    
    /**
     * 検索結果件数を取得.
     * この処理を呼び出すと、パラメータ定義の内容はクリアされます.
     * クリアされなく呼び出したい場合は[count(false)]で実行してください.
     * @return int 検索結果の件数が返却されます.
     */
    public int count() ;
    
    /**
     * 検索結果件数を取得.
     * @param clearMode 処理結果に対して、パラメータ定義などを
     *                  クリアする場合は[true]を設定します.
     * @return int 検索結果の件数が返却されます.
     */
    public int count( boolean clearMode ) ;
    
    /**
     * 検索処理.
     * @return SearchResult 検索結果が返却されます.
     */
    public SearchResult execute() ;
    
    /**
     * 検索処理.
     * @param offset 対象のオフセット値を設定します.
     * @param limit 対象のリミット値を設定します.
     * @return SearchResult 検索結果が返却されます.
     */
    public SearchResult execute( int offset,int limit ) ;
    
    /**
     * 最初の１件だけを取得.
     * @param offset 対象のオフセット値を設定します.
     * @param limit 対象のリミット値を設定します.
     * @return Row 1件の情報が返却されます.
     * @version rimdb-1.01
     */
    public Row first() ;
}
