/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table.array;

import java.sql.Timestamp;
import java.util.Date;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.table.array.ColumnArray;
import org.maachang.rimdb.util.NList;

public final class TimestampArray
implements ColumnArray<Timestamp> {
    private long[] list;
    private int[] nullList;

    public TimestampArray(Date[] columns) {
        NList nulls = new NList();
        int len = columns.length;
        long[] n = new long[len];
        int i = 0;
        while (i < len) {
            if (columns[i] == null) {
                nulls.add(i);
            } else {
                n[i] = columns[i].getTime();
            }
            ++i;
        }
        this.list = n;
        this.nullList = (int[])(nulls.size() == 0 ? null : nulls.sort().getArray());
    }

    public TimestampArray(Timestamp[] columns) {
        NList nulls = new NList();
        int len = columns.length;
        long[] n = new long[len];
        int i = 0;
        while (i < len) {
            if (columns[i] == null) {
                nulls.add(i);
            } else {
                n[i] = columns[i].getTime();
            }
            ++i;
        }
        this.list = n;
        this.nullList = (int[])(nulls.size() == 0 ? null : nulls.sort().getArray());
    }

    @Override
    public final int getType() {
        return 7;
    }

    @Override
    public final Timestamp get(int no) {
        if (this.nullList != null && IndexUtil.searchInt(this.nullList, no) != -1) {
            return null;
        }
        return new Timestamp(this.list[no]);
    }

    public final Timestamp get(Timestamp out, int no) {
        if (this.nullList != null && IndexUtil.searchInt(this.nullList, no) != -1) {
            return null;
        }
        out.setTime(this.list[no]);
        return out;
    }
}

