/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table.array;

import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.table.array.ColumnArray;
import org.maachang.rimdb.util.NList;

public final class FloatArray
implements ColumnArray<Double> {
    private double[] list;
    private int[] nullList;

    public FloatArray(Double[] columns) {
        NList nulls = new NList();
        int len = columns.length;
        double[] n = new double[len];
        int i = 0;
        while (i < len) {
            if (columns[i] == null) {
                nulls.add(i);
            } else {
                n[i] = columns[i];
            }
            ++i;
        }
        this.list = n;
        this.nullList = (int[])(nulls.size() == 0 ? null : nulls.sort().getArray());
    }

    @Override
    public final int getType() {
        return 4;
    }

    @Override
    public final Double get(int no) {
        if (this.nullList != null && IndexUtil.searchInt(this.nullList, no) != -1) {
            return null;
        }
        return this.list[no];
    }
}

