/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table.array;

import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.table.array.ColumnArray;
import org.maachang.rimdb.util.NList;

public final class BooleanArray
implements ColumnArray<Boolean> {
    private static final boolean[] IF;
    private int[] list;
    private int[] nullList;

    static {
        boolean[] blArray = new boolean[2];
        blArray[1] = true;
        IF = blArray;
    }

    public BooleanArray(Boolean[] columns) {
        NList nulls = new NList();
        int len = columns.length;
        int nLen = (len >> 5) + ((len & 0x1F) == 0 ? 0 : 1);
        int[] n = new int[nLen];
        int i = 0;
        while (i < len) {
            if (columns[i] == null) {
                nulls.add(i);
            } else if (columns[i].booleanValue()) {
                int n2 = i >> 5;
                n[n2] = n[n2] | 1 << (i & 0x1F);
            }
            ++i;
        }
        this.list = n;
        this.nullList = (int[])(nulls.size() == 0 ? null : nulls.sort().getArray());
    }

    @Override
    public final int getType() {
        return 1;
    }

    @Override
    public final Boolean get(int no) {
        if (this.nullList != null && IndexUtil.searchInt(this.nullList, no) != -1) {
            return null;
        }
        int n = no & 0x1F;
        return IF[(this.list[no >> 5] & 1 << n) >> n & 1];
    }
}

