/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.maachang.rimdb.ColumnMap;
import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.Row;
import org.maachang.rimdb.index.position.PositionIndex;
import org.maachang.rimdb.table.Columns;
import org.maachang.rimdb.table.TableUtil;
import org.maachang.rimdb.table.array.ColumnArray;
import org.maachang.rimdb.util.ConvertUtil;

final class CopyRow
implements Row {
    protected final Columns columns;
    protected final int[] positionColumns;
    protected final int position;

    protected CopyRow(Columns columns, int[] positionColumns, int position) {
        this.columns = columns;
        this.positionColumns = positionColumns;
        this.position = position;
    }

    @Override
    public final void clear() {
    }

    @Override
    public final Row copy() {
        return new CopyRow(this.columns, this.positionColumns, this.position);
    }

    @Override
    public final ColumnMap toMap() {
        int len = this.columns.length;
        ColumnMap ret = new ColumnMap(len);
        String[] names = this.columns.columnNames;
        ColumnArray[] list = this.columns.list;
        int r = this.position();
        int i = 0;
        while (i < len) {
            ret.put(names[i], list[i].get(r));
            ++i;
        }
        return ret;
    }

    @Override
    public final ColumnMap toJavaMap() {
        int len = this.columns.length;
        ColumnMap ret = new ColumnMap(len);
        String[] names = this.columns.columnNames;
        ColumnArray[] list = this.columns.list;
        int r = this.position();
        int i = 0;
        while (i < len) {
            ret.put(TableUtil.convertDBNameByJavaName(false, names[i]), list[i].get(r));
            ++i;
        }
        return ret;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public final Row position(int pos) {
        throw new RimDbException("\u30b3\u30d4\u30fc\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306e\u884c\u4f4d\u7f6e\u306f\u5909\u66f4\u3067\u304d\u307e\u305b\u3093");
    }

    @Override
    public final int getType(int no) {
        return this.columns.getType(no);
    }

    @Override
    public final int getType(String name) {
        return this.columns.getType(TableUtil.convertJavaNameByDBName(name));
    }

    @Override
    public final int length() {
        return this.columns.length;
    }

    @Override
    public final String getColumnName(int no) {
        return this.columns.columnNames[no];
    }

    @Override
    public final Object getValue(int no) {
        return this.columns.list[no].get(this.position());
    }

    @Override
    public final Object getValue(long no) {
        return this.columns.list[(int)no].get(this.position());
    }

    @Override
    public final Object getValue(String name) {
        if (name == null) {
            return null;
        }
        int p = this.columns.getColumnNo(TableUtil.convertJavaNameByDBName(name));
        if (p == -1) {
            return null;
        }
        return this.columns.list[p].get(this.position());
    }

    private final int _no(Object o) {
        if (o == null) {
            return -1;
        }
        if (o instanceof String) {
            String nm = TableUtil.convertJavaNameByDBName((String)o);
            return this.columns.getColumnNo(nm);
        }
        if (o instanceof Number) {
            int n = ((Number)o).intValue();
            if (n < 0 || n >= this.columns.length) {
                return -1;
            }
            return n;
        }
        if (ConvertUtil.isNumeric(o)) {
            int n = ConvertUtil.convertInt(o);
            if (n < 0 || n >= this.columns.length) {
                return -1;
            }
            return n;
        }
        String nm = TableUtil.convertJavaNameByDBName(ConvertUtil.convertString(o));
        return this.columns.getColumnNo(nm);
    }

    @Override
    public final Object get(Object o) {
        int no = this._no(o);
        if (no == -1) {
            return null;
        }
        return this.columns.list[no].get(this.position());
    }

    @Override
    public final Boolean getBoolean(int no) {
        return ConvertUtil.convertBool(this.getValue(no));
    }

    @Override
    public final Integer getInt(int no) {
        return ConvertUtil.convertInt(this.getValue(no));
    }

    @Override
    public final Long getLong(int no) {
        return ConvertUtil.convertLong(this.getValue(no));
    }

    @Override
    public final Float getFloat(int no) {
        return ConvertUtil.convertFloat(this.getValue(no));
    }

    @Override
    public final Double getDouble(int no) {
        return ConvertUtil.convertDouble(this.getValue(no));
    }

    @Override
    public final String getString(int no) {
        return ConvertUtil.convertString(this.getValue(no));
    }

    @Override
    public final Date getDate(int no) {
        return ConvertUtil.convertSqlDate(this.getValue(no));
    }

    @Override
    public final Time getTime(int no) {
        return ConvertUtil.convertSqlTime(this.getValue(no));
    }

    @Override
    public final Timestamp getTimestamp(int no) {
        return ConvertUtil.convertSqlTimestamp(this.getValue(no));
    }

    @Override
    public final Boolean getBoolean(long no) {
        return ConvertUtil.convertBool(this.getValue(no));
    }

    @Override
    public final Integer getInt(long no) {
        return ConvertUtil.convertInt(this.getValue(no));
    }

    @Override
    public final Long getLong(long no) {
        return ConvertUtil.convertLong(this.getValue(no));
    }

    @Override
    public final Float getFloat(long no) {
        return ConvertUtil.convertFloat(this.getValue(no));
    }

    @Override
    public final Double getDouble(long no) {
        return ConvertUtil.convertDouble(this.getValue(no));
    }

    @Override
    public final String getString(long no) {
        return ConvertUtil.convertString(this.getValue(no));
    }

    @Override
    public final Date getDate(long no) {
        return ConvertUtil.convertSqlDate(this.getValue(no));
    }

    @Override
    public final Time getTime(long no) {
        return ConvertUtil.convertSqlTime(this.getValue(no));
    }

    @Override
    public final Timestamp getTimestamp(long no) {
        return ConvertUtil.convertSqlTimestamp(this.getValue(no));
    }

    @Override
    public final Boolean getBoolean(String key) {
        return ConvertUtil.convertBool(this.getValue(key));
    }

    @Override
    public final Integer getInt(String key) {
        return ConvertUtil.convertInt(this.getValue(key));
    }

    @Override
    public final Long getLong(String key) {
        return ConvertUtil.convertLong(this.getValue(key));
    }

    @Override
    public final Float getFloat(String key) {
        return ConvertUtil.convertFloat(this.getValue(key));
    }

    @Override
    public final Double getDouble(String key) {
        return ConvertUtil.convertDouble(this.getValue(key));
    }

    @Override
    public final String getString(String key) {
        return ConvertUtil.convertString(this.getValue(key));
    }

    @Override
    public final Date getDate(String key) {
        return ConvertUtil.convertSqlDate(this.getValue(key));
    }

    @Override
    public final Time getTime(String key) {
        return ConvertUtil.convertSqlTime(this.getValue(key));
    }

    @Override
    public final Timestamp getTimestamp(String key) {
        return ConvertUtil.convertSqlTimestamp(this.getValue(key));
    }

    @Override
    public final int getPoint(int x, int y) {
        if (this.positionColumns == null) {
            throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        return PositionIndex.getLine(x, y, (Integer)this.columns.list[this.positionColumns[0]].get(this.position()), (Integer)this.columns.list[this.positionColumns[1]].get(this.position()));
    }

    @Override
    public final int getPoint(Number lat, Number lon) {
        if (this.positionColumns == null) {
            throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        int x = lat instanceof Double || lat instanceof Float || lat instanceof BigDecimal ? PositionIndex.getLat(lat.doubleValue()) : lat.intValue();
        int y = lon instanceof Double || lon instanceof Float || lat instanceof BigDecimal ? PositionIndex.getLon(lon.doubleValue()) : lon.intValue();
        return PositionIndex.getLine(x, y, (Integer)this.columns.list[this.positionColumns[0]].get(this.position()), (Integer)this.columns.list[this.positionColumns[1]].get(this.position()));
    }

    @Override
    public final void putAll(Map toMerge) {
    }

    @Override
    public final boolean containsValue(Object value) {
        int len = this.columns.length;
        ColumnArray[] list = this.columns.list;
        int r = this.position();
        if (value == null) {
            int i = 0;
            while (i < len) {
                if (list[i].get(r) == null) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (value.equals(list[i].get(r))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public final Set entrySet() {
        return null;
    }

    @Override
    public final Collection values() {
        int len = this.columns.length;
        ColumnArray[] list = this.columns.list;
        ArrayList ret = new ArrayList();
        int r = this.position();
        int i = 0;
        while (i < len) {
            ret.add(list[i].get(r));
            ++i;
        }
        return ret;
    }

    @Override
    public final Object put(Object name, Object value) {
        return null;
    }

    @Override
    public final boolean containsKey(Object key) {
        return this._no(key) != -1;
    }

    @Override
    public final Object remove(Object key) {
        return null;
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final Set keySet() {
        HashSet<Object> ret = new HashSet<Object>();
        this.getAllKey(ret);
        return ret;
    }

    @Override
    public int size() {
        return this.columns.length;
    }

    public final void getAllKey(Set<Object> set) {
        int len = this.columns.length;
        String[] names = this.columns.columnNames;
        int i = 0;
        while (i < len) {
            set.add(names[i]);
            ++i;
        }
    }

    public final void getAllValues(Set<Object> set) {
        int len = this.columns.length;
        ColumnArray[] list = this.columns.list;
        int r = this.position();
        int i = 0;
        while (i < len) {
            set.add(list[i].get(r));
            ++i;
        }
    }

    public final String toString() {
        int len = this.columns.length;
        String[] names = this.columns.columnNames;
        StringBuilder buf = new StringBuilder();
        ColumnArray[] list = this.columns.list;
        int r = this.position();
        buf.append("{");
        int i = 0;
        while (i < len) {
            Object v;
            if (i != 0) {
                buf.append(",");
            }
            if ((v = list[i].get(r)) instanceof String) {
                buf.append(names[i]).append(":\"").append(v).append("\"");
            } else {
                buf.append(names[i]).append(":").append(v);
            }
            ++i;
        }
        return buf.append("}").toString();
    }
}

