/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.search;

import java.lang.ref.SoftReference;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.rimdb.search.SearchImpl;

public final class CacheSearch {
    private final Map<String, SoftReference<SearchImpl>> cache = new ConcurrentHashMap<String, SoftReference<SearchImpl>>();

    public final void clear() {
        this.cache.clear();
    }

    public final void set(String name, SearchImpl search) {
        if (name != null && search != null) {
            this.cache.put(name, new SoftReference<SearchImpl>(search));
        }
    }

    public final SearchImpl get(String name) {
        SearchImpl ret;
        if (name == null) {
            return null;
        }
        SoftReference<SearchImpl> c = this.cache.get(name);
        if (c != null && (ret = c.get()) != null) {
            return ret.copy();
        }
        if (c != null) {
            this.cache.remove(name);
        }
        return null;
    }

    public final void remove(String name) {
        this.cache.remove(name);
    }
}

