/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index.string;

import java.lang.reflect.Array;
import java.util.List;
import org.maachang.rimdb.index.InPointer;
import org.maachang.rimdb.index.string.IString;
import org.maachang.rimdb.index.string.StringIndex;
import org.maachang.rimdb.util.ConvertUtil;
import org.maachang.rimdb.util.OList;

public final class StringIn
extends InPointer<IString> {
    protected StringIn() {
    }

    public StringIn(StringIndex index) {
        this.type = 2;
        this.columnName = index.getColumnName();
    }

    public StringIn(StringIndex index, OList<IString> word) {
        this(index);
        this.set(word);
    }

    public StringIn(StringIndex index, String ... word) {
        this(index);
        this.set(word);
    }

    public StringIn(StringIndex index, IString ... word) {
        this(index);
        this.set(word);
    }

    public StringIn(StringIndex index, Object word) {
        this(index);
        this.set(word);
    }

    public final void set(String ... word) {
        OList<IString> n = new OList<IString>();
        int len = word.length;
        int i = 0;
        while (i < len) {
            n.add(new IString(word[i]));
            ++i;
        }
        this.set(n);
    }

    public final void set(IString ... word) {
        OList<IString> n = new OList<IString>();
        int len = word.length;
        int i = 0;
        while (i < len) {
            n.add(word[i]);
            ++i;
        }
        this.set(n);
    }

    public final void set(Object word) {
        this.set(StringIn.getWord(word));
    }

    @Override
    public final void parameter(Object word) {
        this.set(StringIn.getWord(word));
    }

    public static final OList<IString> getWord(Object word) {
        if (word instanceof List) {
            List n = (List)word;
            int len = n.size();
            OList<IString> ret = new OList<IString>(len);
            int i = 0;
            while (i < len) {
                ret.add(StringIn.convert(n.get(i)));
                ++i;
            }
            return ret;
        }
        if (word instanceof String[]) {
            String[] n = (String[])word;
            int len = n.length;
            OList<IString> ret = new OList<IString>(len);
            int i = 0;
            while (i < len) {
                ret.add(StringIn.convert(n[i]));
                ++i;
            }
            return ret;
        }
        if (word instanceof Object[]) {
            Object[] n = (Object[])word;
            int len = n.length;
            OList<IString> ret = new OList<IString>(len);
            int i = 0;
            while (i < len) {
                ret.add(StringIn.convert(n[i]));
                ++i;
            }
            return ret;
        }
        if (word instanceof IString[]) {
            IString[] n = (IString[])word;
            int len = n.length;
            OList<IString> ret = new OList<IString>(len);
            int i = 0;
            while (i < len) {
                ret.add(n[i]);
                ++i;
            }
            return ret;
        }
        if (word instanceof OList) {
            OList n = (OList)word;
            if (n.size() != 0 && n.get(0) instanceof IString) {
                return (OList)word;
            }
            int len = n.size();
            OList<IString> ret = new OList<IString>(len);
            int i = 0;
            while (i < len) {
                ret.add(StringIn.convert(n.get(i)));
                ++i;
            }
            return ret;
        }
        if (word.getClass().isArray()) {
            int len = Array.getLength(word);
            OList<IString> ret = new OList<IString>(len);
            int i = 0;
            while (i < len) {
                ret.add(StringIn.convert(Array.get(word, i)));
                ++i;
            }
            return ret;
        }
        OList<IString> ret = new OList<IString>(1);
        ret.add(StringIn.convert(word));
        return ret;
    }

    protected static final IString convert(Object o) {
        if (o instanceof IString) {
            return (IString)o;
        }
        return new IString(ConvertUtil.convertString(o));
    }

    @Override
    public final StringIn copy(boolean mode) {
        StringIn ret = new StringIn();
        this.baseCopy(mode, ret);
        return ret;
    }
}

