/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index;

import org.maachang.rimdb.index.ResultSort;

class ResultTimSort {
    private static final int MIN_MERGE = 32;
    private final ResultSort a;
    private static final int MIN_GALLOP = 7;
    private int minGallop = 7;
    private static final int INITIAL_TMP_STORAGE_LENGTH = 256;
    private int[] tmp;
    private int stackSize = 0;
    private final int[] runBase;
    private final int[] runLen;

    private ResultTimSort(ResultSort a) {
        this.a = a;
        int len = a.length;
        int[] newArray = new int[len < 512 ? len >>> 1 : 256];
        this.tmp = newArray;
        int stackLen = len < 120 ? 5 : (len < 1542 ? 10 : (len < 119151 ? 19 : 40));
        this.runBase = new int[stackLen];
        this.runLen = new int[stackLen];
    }

    public static void sort(ResultSort a) {
        ResultTimSort.sort(a, 0, a.length);
    }

    static void sort(ResultSort a, int lo, int hi) {
        int runLen;
        ResultTimSort.rangeCheck(a.length, lo, hi);
        int nRemaining = hi - lo;
        if (nRemaining < 2) {
            return;
        }
        if (nRemaining < 32) {
            int initRunLen = ResultTimSort.countRunAndMakeAscending(a, lo, hi);
            ResultTimSort.binarySort(a, lo, hi, lo + initRunLen);
            return;
        }
        ResultTimSort ts = new ResultTimSort(a);
        int minRun = ResultTimSort.minRunLength(nRemaining);
        do {
            if ((runLen = ResultTimSort.countRunAndMakeAscending(a, lo, hi)) < minRun) {
                int force = nRemaining <= minRun ? nRemaining : minRun;
                ResultTimSort.binarySort(a, lo, lo + force, lo + runLen);
                runLen = force;
            }
            ts.pushRun(lo, runLen);
            ts.mergeCollapse();
            lo += runLen;
        } while ((nRemaining -= runLen) != 0);
        ts.mergeForceCollapse();
    }

    private static void binarySort(ResultSort a, int lo, int hi, int start) {
        if (start == lo) {
            ++start;
        }
        int[] rows = a.rows;
        while (start < hi) {
            int pivot = rows[start];
            int left = lo;
            int right = start;
            while (left < right) {
                int mid = left + right >>> 1;
                if (a.raw(pivot, rows[mid]) < 0) {
                    right = mid;
                    continue;
                }
                left = mid + 1;
            }
            int n = start - left;
            switch (n) {
                case 2: {
                    rows[left + 2] = rows[left + 1];
                }
                case 1: {
                    rows[left + 1] = rows[left];
                    break;
                }
                default: {
                    System.arraycopy(rows, left, rows, left + 1, n);
                }
            }
            rows[left] = pivot;
            ++start;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int countRunAndMakeAscending(ResultSort a, int lo, int hi) {
        block3: {
            runHi = lo + 1;
            if (runHi == hi) {
                return 1;
            }
            if (a.comparable(runHi++, lo) >= 0) ** GOTO lbl11
            while (runHi < hi && a.comparable(runHi, runHi - 1) < 0) {
                ++runHi;
            }
            ResultTimSort.reverseRange(a, lo, runHi);
            break block3;
lbl-1000:
            // 1 sources

            {
                ++runHi;
lbl11:
                // 2 sources

                ** while (runHi < hi && a.comparable((int)runHi, (int)(runHi - 1)) >= 0)
            }
        }
        return runHi - lo;
    }

    private static void reverseRange(ResultSort a, int lo, int hi) {
        --hi;
        int[] rows = a.rows;
        while (lo < hi) {
            int t = rows[lo];
            rows[lo++] = rows[hi];
            rows[hi--] = t;
        }
    }

    private static int minRunLength(int n) {
        int r = 0;
        while (n >= 32) {
            r |= n & 1;
            n >>= 1;
        }
        return n + r;
    }

    private void pushRun(int runBase, int runLen) {
        this.runBase[this.stackSize] = runBase;
        this.runLen[this.stackSize] = runLen;
        ++this.stackSize;
    }

    private void mergeCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n > 0 && this.runLen[n - 1] <= this.runLen[n] + this.runLen[n + 1]) {
                if (this.runLen[n - 1] < this.runLen[n + 1]) {
                    --n;
                }
                this.mergeAt(n);
                continue;
            }
            if (this.runLen[n] > this.runLen[n + 1]) break;
            this.mergeAt(n);
        }
    }

    private void mergeForceCollapse() {
        while (this.stackSize > 1) {
            int n = this.stackSize - 2;
            if (n > 0 && this.runLen[n - 1] < this.runLen[n + 1]) {
                --n;
            }
            this.mergeAt(n);
        }
    }

    private void mergeAt(int i) {
        int base1 = this.runBase[i];
        int len1 = this.runLen[i];
        int base2 = this.runBase[i + 1];
        int len2 = this.runLen[i + 1];
        this.runLen[i] = len1 + len2;
        if (i == this.stackSize - 3) {
            this.runBase[i + 1] = this.runBase[i + 2];
            this.runLen[i + 1] = this.runLen[i + 2];
        }
        --this.stackSize;
        int[] rows = this.a.rows;
        int k = ResultTimSort.gallopRight(rows[base2], this.a, rows, base1, len1, 0);
        base1 += k;
        if ((len1 -= k) == 0) {
            return;
        }
        if ((len2 = ResultTimSort.gallopLeft(rows[base1 + len1 - 1], this.a, rows, base2, len2, len2 - 1)) == 0) {
            return;
        }
        if (len1 <= len2) {
            this.mergeLo(base1, len1, base2, len2);
        } else {
            this.mergeHi(base1, len1, base2, len2);
        }
    }

    private static int gallopLeft(int key, ResultSort a, int[] rows, int base, int len, int hint) {
        int maxOfs;
        int lastOfs = 0;
        int ofs = 1;
        if (a.raw(key, rows[base + hint]) > 0) {
            maxOfs = len - hint;
            while (ofs < maxOfs && a.raw(key, rows[base + hint + ofs]) > 0) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            lastOfs += hint;
            ofs += hint;
        } else {
            maxOfs = hint + 1;
            while (ofs < maxOfs && a.raw(key, rows[base + hint - ofs]) <= 0) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            int tmp = lastOfs;
            lastOfs = hint - ofs;
            ofs = hint - tmp;
        }
        ++lastOfs;
        while (lastOfs < ofs) {
            int m = lastOfs + (ofs - lastOfs >>> 1);
            if (a.raw(key, rows[base + m]) > 0) {
                lastOfs = m + 1;
                continue;
            }
            ofs = m;
        }
        return ofs;
    }

    private static <T> int gallopRight(int key, ResultSort a, int[] rows, int base, int len, int hint) {
        int maxOfs;
        int ofs = 1;
        int lastOfs = 0;
        if (a.raw(key, rows[base + hint]) < 0) {
            maxOfs = hint + 1;
            while (ofs < maxOfs && a.raw(key, rows[base + hint - ofs]) < 0) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            int tmp = lastOfs;
            lastOfs = hint - ofs;
            ofs = hint - tmp;
        } else {
            maxOfs = len - hint;
            while (ofs < maxOfs && a.raw(key, rows[base + hint + ofs]) >= 0) {
                lastOfs = ofs;
                if ((ofs = (ofs << 1) + 1) > 0) continue;
                ofs = maxOfs;
            }
            if (ofs > maxOfs) {
                ofs = maxOfs;
            }
            lastOfs += hint;
            ofs += hint;
        }
        ++lastOfs;
        while (lastOfs < ofs) {
            int m = lastOfs + (ofs - lastOfs >>> 1);
            if (a.raw(key, rows[base + m]) < 0) {
                ofs = m;
                continue;
            }
            lastOfs = m + 1;
        }
        return ofs;
    }

    private void mergeLo(int base1, int len1, int base2, int len2) {
        ResultSort a = this.a;
        int[] rows = a.rows;
        int[] tmp = this.ensureCapacity(len1);
        System.arraycopy(rows, base1, tmp, 0, len1);
        int cursor1 = 0;
        int cursor2 = base2;
        int dest = base1;
        rows[dest++] = rows[cursor2++];
        if (--len2 == 0) {
            System.arraycopy(tmp, cursor1, rows, dest, len1);
            return;
        }
        if (len1 == 1) {
            System.arraycopy(rows, cursor2, rows, dest, len2);
            rows[dest + len2] = tmp[cursor1];
            return;
        }
        int minGallop = this.minGallop;
        block0: while (true) {
            int count1 = 0;
            int count2 = 0;
            do {
                if (a.raw(rows[cursor2], tmp[cursor1]) < 0) {
                    rows[dest++] = rows[cursor2++];
                    ++count2;
                    count1 = 0;
                    if (--len2 != 0) continue;
                    break block0;
                }
                rows[dest++] = tmp[cursor1++];
                ++count1;
                count2 = 0;
                if (--len1 == 1) break block0;
            } while ((count1 | count2) < minGallop);
            do {
                if ((count1 = ResultTimSort.gallopRight(rows[cursor2], a, tmp, cursor1, len1, 0)) != 0) {
                    System.arraycopy(tmp, cursor1, rows, dest, count1);
                    dest += count1;
                    cursor1 += count1;
                    if ((len1 -= count1) <= 1) break block0;
                }
                rows[dest++] = rows[cursor2++];
                if (--len2 == 0) break block0;
                count2 = ResultTimSort.gallopLeft(tmp[cursor1], a, rows, cursor2, len2, 0);
                if (count2 != 0) {
                    System.arraycopy(rows, cursor2, rows, dest, count2);
                    dest += count2;
                    cursor2 += count2;
                    if ((len2 -= count2) == 0) break block0;
                }
                rows[dest++] = tmp[cursor1++];
                if (--len1 == 1) break block0;
                --minGallop;
            } while (count1 >= 7 | count2 >= 7);
            if (minGallop < 0) {
                minGallop = 0;
            }
            minGallop += 2;
        }
        int n = this.minGallop = minGallop < 1 ? 1 : minGallop;
        if (len1 == 1) {
            System.arraycopy(rows, cursor2, rows, dest, len2);
            rows[dest + len2] = tmp[cursor1];
        } else {
            if (len1 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            System.arraycopy(tmp, cursor1, rows, dest, len1);
        }
    }

    private void mergeHi(int base1, int len1, int base2, int len2) {
        ResultSort a = this.a;
        int[] rows = a.rows;
        int[] tmp = this.ensureCapacity(len2);
        System.arraycopy(rows, base2, tmp, 0, len2);
        int cursor1 = base1 + len1 - 1;
        int cursor2 = len2 - 1;
        int dest = base2 + len2 - 1;
        rows[dest--] = rows[cursor1--];
        if (--len1 == 0) {
            System.arraycopy(tmp, 0, rows, dest - (len2 - 1), len2);
            return;
        }
        if (len2 == 1) {
            System.arraycopy(rows, (cursor1 -= len1) + 1, rows, (dest -= len1) + 1, len1);
            rows[dest] = tmp[cursor2];
            return;
        }
        int minGallop = this.minGallop;
        block0: while (true) {
            int count1 = 0;
            int count2 = 0;
            do {
                if (a.raw(tmp[cursor2], rows[cursor1]) < 0) {
                    rows[dest--] = rows[cursor1--];
                    ++count1;
                    count2 = 0;
                    if (--len1 != 0) continue;
                    break block0;
                }
                rows[dest--] = tmp[cursor2--];
                ++count2;
                count1 = 0;
                if (--len2 == 1) break block0;
            } while ((count1 | count2) < minGallop);
            do {
                if ((count1 = len1 - ResultTimSort.gallopRight(tmp[cursor2], a, rows, base1, len1, len1 - 1)) != 0) {
                    System.arraycopy(rows, (cursor1 -= count1) + 1, rows, (dest -= count1) + 1, count1);
                    if ((len1 -= count1) == 0) break block0;
                }
                rows[dest--] = tmp[cursor2--];
                if (--len2 == 1) break block0;
                count2 = len2 - ResultTimSort.gallopLeft(rows[cursor1], a, tmp, 0, len2, len2 - 1);
                if (count2 != 0) {
                    System.arraycopy(tmp, (cursor2 -= count2) + 1, rows, (dest -= count2) + 1, count2);
                    if ((len2 -= count2) <= 1) break block0;
                }
                rows[dest--] = rows[cursor1--];
                if (--len1 == 0) break block0;
                --minGallop;
            } while (count1 >= 7 | count2 >= 7);
            if (minGallop < 0) {
                minGallop = 0;
            }
            minGallop += 2;
        }
        int n = this.minGallop = minGallop < 1 ? 1 : minGallop;
        if (len2 == 1) {
            System.arraycopy(rows, (cursor1 -= len1) + 1, rows, (dest -= len1) + 1, len1);
            rows[dest] = tmp[cursor2];
        } else {
            if (len2 == 0) {
                throw new IllegalArgumentException("Comparison method violates its general contract!");
            }
            System.arraycopy(tmp, 0, rows, dest - (len2 - 1), len2);
        }
    }

    private int[] ensureCapacity(int minCapacity) {
        if (this.tmp.length < minCapacity) {
            int newSize = minCapacity;
            newSize |= newSize >> 1;
            newSize |= newSize >> 2;
            newSize |= newSize >> 4;
            newSize |= newSize >> 8;
            newSize |= newSize >> 16;
            newSize = ++newSize < 0 ? minCapacity : Math.min(newSize, this.a.length >>> 1);
            int[] newArray = new int[newSize];
            this.tmp = newArray;
        }
        return this.tmp;
    }

    private static void rangeCheck(int arrayLen, int fromIndex, int toIndex) {
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (fromIndex < 0) {
            throw new ArrayIndexOutOfBoundsException(fromIndex);
        }
        if (toIndex > arrayLen) {
            throw new ArrayIndexOutOfBoundsException(toIndex);
        }
    }
}

