/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index;

import java.util.Arrays;
import org.maachang.rimdb.index.SortLines;

public final class ResultRadixSort {
    protected ResultRadixSort() {
    }

    public static final void sort(SortLines sortLines, boolean desc, int[] list, int length, int max) {
        if (length > 64) {
            ResultRadixSort.rsort(desc, sortLines.list, list, length, max);
        } else {
            ResultRadixSort.csort(desc, sortLines.list, list, length);
        }
    }

    protected static final void rsort(boolean desc, int[] sortLines, int[] list, int length, int max) {
        int len = max < 256 ? 8 : (max < 65536 ? 16 : (max < 0x1000000 ? 24 : 32));
        int[] h = new int[256];
        int[] b = new int[length];
        int shift = 0;
        while (shift < len) {
            int i = 0;
            while (i < length) {
                int n = sortLines[list[i]] >> shift & 0xFF;
                h[n] = h[n] + 1;
                b[i] = list[i];
                ++i;
            }
            if (desc) {
                i = 255;
                while (i > 0) {
                    int n = i - 1;
                    h[n] = h[n] + h[i];
                    --i;
                }
            } else {
                i = 1;
                while (i < 256) {
                    int n = i;
                    h[n] = h[n] + h[i - 1];
                    ++i;
                }
            }
            i = length;
            while (i > 0) {
                int bb = b[--i];
                int n = sortLines[bb] >> shift & 0xFF;
                int n2 = h[n] - 1;
                h[n] = n2;
                list[n2] = bb;
            }
            Arrays.fill(h, 0, 256, 0);
            shift += 8;
        }
    }

    /*
     * Unable to fully structure code
     */
    protected static final void csort(boolean desc, int[] sortLines, int[] list, int length) {
        block15: {
            gap = length;
            if (!desc) ** GOTO lbl44
            while (gap > 20) {
                if ((gap = (int)((double)gap / 1.37)) == 9 || gap == 10) {
                    gap = 11;
                }
                i = 0;
                while (i + gap < length) {
                    if (sortLines[list[i + gap]] > sortLines[list[i]]) {
                        t = list[i];
                        list[i] = list[i + gap];
                        list[i + gap] = t;
                    }
                    ++i;
                }
            }
            i = 1;
            while (i < length) {
                block14: {
                    t = list[i];
                    j = i;
                    k = i;
                    if (sortLines[t] <= sortLines[list[0]]) ** GOTO lbl28
                    while (j > 0) {
                        list[j] = list[--k];
                        j = k;
                    }
                    break block14;
lbl-1000:
                    // 1 sources

                    {
                        list[j] = list[k];
                        j = k;
lbl28:
                        // 2 sources

                        ** while (sortLines[t] > sortLines[list[--k]])
                    }
                }
                list[j] = t;
                ++i;
            }
            break block15;
lbl-1000:
            // 1 sources

            {
                if ((gap = (int)((double)gap / 1.37)) == 9 || gap == 10) {
                    gap = 11;
                }
                i = 0;
                while (i + gap < length) {
                    if (sortLines[list[i + gap]] < sortLines[list[i]]) {
                        t = list[i];
                        list[i] = list[i + gap];
                        list[i + gap] = t;
                    }
                    ++i;
                }
lbl44:
                // 2 sources

                ** while (gap > 20)
            }
lbl45:
            // 1 sources

            i = 1;
            while (i < length) {
                block16: {
                    t = list[i];
                    j = i;
                    k = i;
                    if (sortLines[t] >= sortLines[list[0]]) ** GOTO lbl58
                    while (j > 0) {
                        list[j] = list[--k];
                        j = k;
                    }
                    break block16;
lbl-1000:
                    // 1 sources

                    {
                        list[j] = list[k];
                        j = k;
lbl58:
                        // 2 sources

                        ** while (sortLines[t] < sortLines[list[--k]])
                    }
                }
                list[j] = t;
                ++i;
            }
        }
    }
}

