/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index;

import org.maachang.rimdb.index.Mask;
import org.maachang.rimdb.util.NOKeyValue;

public final class MaskLine {
    public final int[] index;
    public final int[] maskList;
    public final int length;
    public final int count;

    public static final MaskLine[] create(int[][] line) {
        int cnt = 0;
        int len = line.length;
        MaskLine[] ret = new MaskLine[len];
        int i = 0;
        while (i < len) {
            ret[i] = new MaskLine(line[i], cnt);
            cnt += ret[i].length;
            ++i;
        }
        return ret;
    }

    protected MaskLine(int[] line, int cnt) {
        int len = line.length;
        NOKeyValue<Mask> list = new NOKeyValue<Mask>(len);
        int i = 0;
        while (i < len) {
            int no = line[i];
            int key = no >> 5;
            Mask n = (Mask)list.get(key);
            if (n == null) {
                list.put(key, new Mask(1 << (no & 0x1F)));
            } else {
                n.value |= 1 << (no & 0x1F);
            }
            ++i;
        }
        len = list.size();
        int[] idx = new int[len];
        int[] msk = new int[len];
        i = 0;
        list.reset();
        while (list.hasNext()) {
            idx[i] = list.next();
            msk[i++] = ((Mask)list.nextValue()).value;
        }
        this.index = idx;
        this.maskList = msk;
        this.length = line.length;
        this.count = cnt;
    }
}

