/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index;

import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.util.NList;

public final class LineIndex {
    private final Object[] index;

    public LineIndex(int[][] line, int max) {
        NList list;
        int lenJ;
        int len = line.length;
        Object[] n = new Object[(max >> 5) + ((max & 0x1F) != 0 ? 1 : 0)];
        int i = 0;
        while (i < len) {
            int[] lm = line[i];
            lenJ = lm.length;
            int j = 0;
            while (j < lenJ) {
                int k = lm[j] >> 5;
                list = (NList)n[k];
                if (list == null) {
                    list = new NList();
                    n[k] = list;
                }
                list.add(i);
                ++j;
            }
            ++i;
        }
        len = n.length;
        i = 0;
        while (i < len) {
            list = (NList)n[i];
            list.sort();
            lenJ = list.size();
            n[i] = list.getArray();
            ++i;
        }
        this.index = n;
    }

    public final int[] getArray(int maskNo) {
        return (int[])this.index[maskNo];
    }

    public final int search(int[] array, int no) {
        return IndexUtil.searchInt(array, no);
    }

    public final int searchBig(boolean eq, int[] array, int no) {
        if (eq) {
            return IndexUtil.searchIntBS(true, array, no);
        }
        int n = IndexUtil.searchIntBS(true, array, no);
        if (n == no && ++n >= array.length) {
            return -1;
        }
        return n;
    }

    public final int searchSmall(boolean eq, int[] array, int no) {
        if (eq) {
            return IndexUtil.searchIntBS(false, array, no);
        }
        int n = IndexUtil.searchIntBS(false, array, no);
        if (n == no && --n < 0) {
            return -1;
        }
        return n;
    }
}

