/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.index.MaskLine;
import org.maachang.rimdb.index.SearchPointer;
import org.maachang.rimdb.util.NAdd;
import org.maachang.rimdb.util.NList;

public abstract class LikePointer<W>
extends SearchPointer<Index<W>> {
    protected NList position;
    protected String word;

    @Override
    public void reset(boolean mode) {
        super.reset(mode);
        if (mode) {
            this.word = null;
        }
        this.position = null;
    }

    public void set(String word) {
        if (word == null) {
            throw new RimDbException("[" + this.getClass().getName() + "]\u691c\u7d22\u6761\u4ef6\u306bnull\u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        this.word = word;
        this.resetFlag = false;
    }

    public final NList position() {
        return this.position;
    }

    @Override
    public final void search(Index<W> index) {
        if (this.resetFlag) {
            throw new RimDbException("[" + this.getClass().getName() + "]\u6761\u4ef6\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.position == null) {
            this.position = new NList();
        } else {
            this.position.clear();
        }
        index.like(this.position, this.word);
        int len = this.position.size();
        MaskLine[] lm = index.getMaskLine();
        int cnt = 0;
        int i = 0;
        while (i < len) {
            cnt += lm[this.position.get((int)i)].length;
            ++i;
        }
        this.count = cnt;
        this.length = len;
    }

    @Override
    public final void get(NAdd out, Index<W> index) {
        NList pos = this.position;
        if (pos.size() == 0) {
            return;
        }
        int[][] indexToLine = index.getIndexToLine();
        int len = pos.size();
        int i = 0;
        while (i < len) {
            int[] n = indexToLine[pos.get(i)];
            int lenJ = n.length;
            int j = 0;
            while (j < lenJ) {
                out.add(n[j]);
                ++j;
            }
            ++i;
        }
    }

    protected void baseCopy(boolean mode, LikePointer o) {
        super.baseCopy(mode, o);
        if (!mode) {
            o.word = this.word;
            o.resetFlag = false;
        }
        o.position = null;
    }
}

