/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.leveldb;

import java.io.File;
import org.maachang.leveldb.JniBuffer;
import org.maachang.leveldb.LeveldbException;
import org.maachang.leveldb.LeveldbIterator;
import org.maachang.leveldb.jni;

public final class Leveldb {
    protected volatile boolean closeFlag = true;
    protected long addr = 0L;
    protected String path;
    protected int write_buffer_size;
    protected int max_open_files;
    protected int block_size;
    protected int block_restart_interval;

    public Leveldb(String path) throws Exception {
        this(path, -1, -1, -1, -1);
    }

    public Leveldb(String path, int write_buffer_size, int max_open_files, int block_size, int block_restart_interval) throws Exception {
        if (path == null || (path = path.trim()).length() <= 0) {
            return;
        }
        if (write_buffer_size < 0) {
            write_buffer_size = -1;
        }
        if (max_open_files < 0) {
            max_open_files = -1;
        }
        if (block_size < 0) {
            block_size = -1;
        }
        if (block_restart_interval < 0) {
            block_restart_interval = -1;
        }
        File f = new File(path);
        String s = f.getCanonicalPath();
        JniBuffer b = new JniBuffer();
        b.setJniChar(s);
        long a = jni.leveldb_open(b.address(), write_buffer_size, max_open_files, block_size, block_restart_interval);
        b.destroy();
        if (a == 0L) {
            throw new LeveldbException("Leveldb\u306e\u30aa\u30fc\u30d7\u30f3\u306b\u5931\u6557:" + s);
        }
        this.addr = a;
        this.path = s;
        this.write_buffer_size = write_buffer_size;
        this.max_open_files = max_open_files;
        this.block_size = block_size;
        this.block_restart_interval = block_restart_interval;
        this.closeFlag = false;
    }

    protected final void finalize() throws Exception {
        this.close();
    }

    public final synchronized void close() {
        if (!this.closeFlag && this.addr != 0L) {
            this.closeFlag = true;
            jni.leveldb_close(this.addr);
            this.addr = 0L;
        }
    }

    public final boolean isClose() {
        return this.closeFlag;
    }

    protected final void check() {
        if (this.closeFlag) {
            throw new LeveldbException("\u65e2\u306b\u30af\u30ed\u30fc\u30ba\u3055\u308c\u3066\u3044\u307e\u3059");
        }
    }

    public final String getPath() {
        return this.path;
    }

    public final int write_buffer_size() {
        return this.write_buffer_size;
    }

    public final int max_open_files() {
        return this.max_open_files;
    }

    public final int block_size() {
        return this.block_size;
    }

    public final int block_restart_interval() {
        return this.block_restart_interval;
    }

    public final void put(JniBuffer key, JniBuffer value) {
        this.check();
        if (key.position() == 0 || value.position() == 0) {
            throw new LeveldbException("\u5f15\u6570\u306f\u4e0d\u6b63\u3067\u3059");
        }
        if (jni.leveldb_put(this.addr, key.address(), key.position(), value.address(), value.position()) == -1) {
            throw new LeveldbException("\u66f8\u304d\u8fbc\u307f\u51e6\u7406\u306f\u5931\u6557\u3057\u307e\u3057\u305f");
        }
    }

    public final int get(JniBuffer out, JniBuffer key) {
        this.check();
        if (key.position() == 0) {
            throw new LeveldbException("\u30ad\u30fc\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        long[] n = new long[]{out.address()};
        int len = jni.leveldb_get(this.addr, key.address(), key.position(), n, out.length());
        if (len <= 0) {
            return 0;
        }
        if (len > out.length()) {
            out.set(n[0], len, len);
        } else {
            out.position(len);
        }
        return len;
    }

    public final boolean remove(JniBuffer key) {
        this.check();
        if (key.position() == 0) {
            throw new LeveldbException("\u30ad\u30fc\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        return jni.leveldb_remove(this.addr, key.address(), key.position()) != -1;
    }

    public final int property(JniBuffer out, JniBuffer cmd) {
        this.check();
        if (cmd.position() == 0) {
            throw new LeveldbException("\u30b3\u30de\u30f3\u30c9\u60c5\u5831\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        long[] n = new long[]{out.address()};
        int len = jni.leveldb_property(this.addr, cmd.address(), cmd.position(), n, out.length());
        if (len <= 0) {
            return 0;
        }
        if (len > out.length()) {
            out.set(n[0], len, len);
        } else {
            out.position(len);
        }
        return len;
    }

    public final LeveldbIterator iterator() {
        return new LeveldbIterator(this);
    }

    public static final void destroy(String path) throws Exception {
        Leveldb.destroy(path, -1, -1, -1, -1);
    }

    public static final void destroy(String path, int write_buffer_size, int max_open_files, int block_size, int block_restart_interval) throws Exception {
        if (path == null || (path = path.trim()).length() <= 0) {
            return;
        }
        if (write_buffer_size < 0) {
            write_buffer_size = -1;
        }
        if (max_open_files < 0) {
            max_open_files = -1;
        }
        if (block_size < 0) {
            block_size = -1;
        }
        if (block_restart_interval < 0) {
            block_restart_interval = -1;
        }
        File f = new File(path);
        String s = f.getCanonicalPath();
        JniBuffer b = new JniBuffer();
        b.setJniChar(s);
        jni.leveldb_destroy(b.address(), write_buffer_size, max_open_files, block_size, block_restart_interval);
        b.destroy();
    }

    public static final void repair(String path) throws Exception {
        Leveldb.repair(path, -1, -1, -1, -1);
    }

    public static final void repair(String path, int write_buffer_size, int max_open_files, int block_size, int block_restart_interval) throws Exception {
        if (path == null || (path = path.trim()).length() <= 0) {
            return;
        }
        if (write_buffer_size < 0) {
            write_buffer_size = -1;
        }
        if (max_open_files < 0) {
            max_open_files = -1;
        }
        if (block_size < 0) {
            block_size = -1;
        }
        if (block_restart_interval < 0) {
            block_restart_interval = -1;
        }
        File f = new File(path);
        String s = f.getCanonicalPath();
        JniBuffer b = new JniBuffer();
        b.setJniChar(s);
        jni.leveldb_repair(b.address(), write_buffer_size, max_open_files, block_size, block_restart_interval);
        b.destroy();
    }
}

