package test ;

import org.maachang.rimdb.* ;
import org.maachang.rimdb.index.position.PositionIndex;

// サンプル3.
// 空間インデックスを利用.
// 空間インデックスは、テーブルコンフィグで、空間インデックスカラム定義を
// している必要があります.
//
public final class Sample3 {
    
    public static final void main( String[] args ) throws Exception {
        
        double lat,lon ;
        
        // 六本木ヒルズを基点とする.
        lat = 35.657291560854915 ;
        lon = 139.73246067555758 ;
        
        // 緯度をメートル換算.
        int latM = PositionIndex.getLat( lat ) ;
        
        // 経度をメートル換算.
        int lonM = PositionIndex.getLon( lon ) ;
        
        // コンフィグファイル名.
        // ※環境に合わせて変更してください.
        String confFile = "/C:/project/java/project/ReadInMemoryDB/sample/conf/rimdb.conf" ;
        
        // rimdbの定義を読み込む.
        TableFactory factory = TableFactory.getInstance() ;
        factory.init( confFile ) ;
        
        // test名でSearchオブジェクトをキャッシュして、SQL文を解析.
        Search s = Sql.create( "$test from test_point_table where point ? order by point asc ;" ) ;
        
        // 空間インデックスのパラメータをセット.
        s.setParameter( 0,
            latM,        // 1 : 緯度をメートル指定.
            lonM,        // 2 : 経度をメートル指定.
            5000 ) ;     // 3 : 半径(5000m => 5km).
        
        // 実行処理.
        SearchResult res = s.execute() ;
        
        // 処理件数を取得.
        System.out.println( res.getLength() + "件の情報を取得" ) ;
        
        // 取得結果を出力.
        while( res.hasNext() ) {
            Row row = res.next() ;
            System.out.println( row + " [距離]:" + row.getPoint( latM,lonM ) ) ;
        }
        
    }
}
