package org.maachang.rimdb.util ;

/**
 * 数字KeySet.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class NSet {
    private static final int DEF_LENGTH = 8 ;
    private static final int MIN_LENGTH = 4 ;
    
    private static final class NSetChild {
        int b ;
        NSetChild n ;
        NSetChild( int v ) {
            b = v ;
        }
        NSetChild( int v,NSetChild nn ) {
            b = v ;
            n = nn ;
        }
    }
    
    private NSetChild[] list ;
    private int mask ;
    private int length ;
    private int limit ;
    private int base ;
    
    /**
     * コンストラクタ.
     */
    public NSet() {
        this( DEF_LENGTH ) ;
    }
    
    /**
     * コンストラクタ.
     * @param size 初期サイズを設定します.
     */
    public NSet( int size ) {
        if( size < MIN_LENGTH ) {
            size = MIN_LENGTH ;
        }
        size = ConvertUtil.bitMask( size ) ;
        list = new NSetChild[ size ] ;
        length = 0 ;
        mask = size - 1 ;
        limit = size ;
        base = size ;
    }
    
    /**
     * クリア.
     */
    public void clear() {
        list = new NSetChild[ base ] ;
        length = 0 ;
        mask = base - 1 ;
        limit = base ;
    }
    
    /**
     * 数値追加.
     * @param b 対象の数値を設定します.
     */
    public void add( int b ) {
        int h ;
        if( length + 1 >= limit ) {
            int nLen = limit << 1 ;
            int msk = nLen - 1 ;
            NSetChild[] nList = new NSetChild[ nLen ] ;
            NSetChild n,t ;
            for( int i = 0 ; i < limit ; i ++ ) {
                n = list[ i ] ;
                while( n != null ) {
                    if( nList[ ( h = n.b & msk ) ] == null ) {
                        t = n.n ;
                        n.n = null ;
                    }
                    else {
                        t = n.n ;
                        n.n = nList[ h ] ;
                    }
                    nList[ h ] = n ;
                    n = t ;
                }
            }
            list = nList ;
            limit = nLen ;
            mask = msk ;
        }
        if( list[ ( h = b & mask ) ] == null ) {
            list[ h ] = new NSetChild( b ) ;
            length ++ ;
        }
        else {
            NSetChild nn = list[ h ] ;
            while( nn.n != null ) {
                if( nn.b == b ) {
                    return ;
                }
                nn = nn.n ;
            }
            if( nn.b != b ) {
                nn.n = new NSetChild( b ) ;
                length ++ ;
            }
        }
    }
    
    /**
     * 情報が存在するかチェック.
     * @param b 対象の数値を設定します.
     * @return boolean [true]の場合、数値は存在します.
     */
    public boolean contains( int b ) {
        if( list[ b & mask ] != null ) {
            NSetChild n = list[ b & mask ] ;
            while( n != null ) {
                if( n.b == b ) {
                    return true ;
                }
                n = n.n ;
            }
        }
        return false ;
    }
    
    /**
     * 削除処理.
     * @param b 対象の数値を設定します.
     */
    public void remove( int b ) {
        if( list[ b & mask ] != null ) {
            NSetChild bf = null ;
            NSetChild n = list[ b & mask ] ;
            while( n != null ) {
                if( n.b == b ) {
                    if( bf == null ) {
                        if( n.n == null ) {
                            list[ b & mask ] = null ;
                        }
                        else {
                            list[ b & mask ] = n.n ;
                        }
                    }
                    else {
                        if( n.n == null ) {
                            bf.n = null ;
                        }
                        else {
                            bf.n = n.n ;
                        }
                    }
                    length -- ;
                    break ;
                }
                bf = n ;
                n = n.n ;
            }
        }
    }
    
    /**
     * サイズを取得.
     * @return int サイズが返却されます.
     */
    public int size() {
        return length ;
    }
    
    /**
     * 数値配列として返却.
     * @return int[] 数値配列として返却します.
     */
    public int[] array() {
        if( length <= 0 ) {
            return null ;
        }
        NSetChild n ;
        int cnt = 0 ;
        int[] ret = new int[ length ] ;
        for( int i = 0 ; i < limit ; i ++ ) {
            if( list[ i ] != null ) {
                n = list[ i ] ;
                while( n != null ) {
                    ret[ cnt ++ ] = n.b ;
                    n = n.n ;
                }
            }
        }
        return ret ;
    }
    
    /** 位置読み込み条件. **/
    private int pos = 0 ;
    private NSetChild cPos = null ;
    
    /**
     * 読み込み中の位置をリセット.
     * @return NSet このオブジェクトが返却されます.
     */
    public NSet reset() {
        pos = 0 ;
        cPos = null ;
        return this ;
    }
    
    /**
     * 次の読み込み条件を取得.
     * @return boolean [true]が返却された場合、情報は存在します.
     */
    public boolean hasNext() {
        if( cPos != null ) {
            if( ( cPos = cPos.n ) != null ) {
                return true ;
            }
        }
        while( pos < limit ) {
            if( ( cPos = list[ pos ++ ] ) != null ) {
                return true ;
            }
        }
        return false ;
    }
    
    /**
     * 現在の読み込み位置の情報を取得.
     * @return int 現在の読み込み位置の内容が返却されます.
     *             [-1]の場合は、情報は存在しません.
     */
    public int next() {
        if( cPos == null ) {
            return -1 ;
        }
        return cPos.b ;
    }
    
}
