package org.maachang.rimdb.table ;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.util.CsvReader;

/**
 * CSVからテーブル作成.
 * 
 * @version 2014/07/10
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class CsvTable extends LoadTable {
    
    /** ファイル名. **/
    protected String fileName ;
    
    /** 文字コード. **/
    protected String charset ;
    
    /** ヘッダ処理フラグ. **/
    protected boolean headerFlag ;
    
    /**
     * コンストラクタ.
     * @param header ヘッダを読み込む場合は[true]をセットします.
     * @param charset 文字コードを設定します.
     * @param name 対象のファイル名を設定します.
     */
    public CsvTable( boolean header,String name ) {
        this( header,null,name ) ;
    }
    
    /**
     * コンストラクタ.
     * @param header ヘッダを読み込む場合は[true]をセットします.
     * @param charset 文字コードを設定します.
     * @param name 対象のファイル名を設定します.
     */
    public CsvTable( boolean header,String charset,String name ) {
        if( charset == null ) {
            charset = "Windows-31J" ;
        }
        this.fileName = name ;
        this.charset = charset ;
        this.headerFlag = header ;
    }
    
    /**
     * テーブル作成.
     * @return Table 新しいテーブルオブジェクトが返却されます.
     */
    public final TableImpl create() {
        if( createTable == null ) {
            throw new RimDbException( "テーブル定義が行われていません" ) ;
        }
        try {
            int i,len ;
            String[] list ;
            int[] columnNoList ;
            final String[] columns = createTable.getColumns() ;
            CsvReader reader = new CsvReader( fileName,charset,"," ) ;
            
            // ヘッダを読み込む場合.
            if( headerFlag ) {
                if( !reader.next() ) {
                    throw new RimDbException( "ヘッダ情報は存在しません" ) ;
                }
                list = reader.getArray() ;
                columnNoList = TableUtil.headerColumnByNoList( columns,list ) ;
                len = columnNoList.length ;
            }
            // ヘッダを読み込まない場合.
            else {
                len = columns.length ;
                columnNoList = new int[ len ] ;
                for( i = 0 ; i < len ; i ++ ) {
                    columnNoList[ i ] = i ;
                }
            }
            
            // CSV読み込み.
            while( reader.next() ) {
                list = reader.getArray() ;
                if( list != null && list.length == len ) {
                    createTable.next() ;
                    for( i = 0 ; i < len ; i ++ ) {
                        createTable.set( columnNoList[ i ],list[ i ] ) ;
                    }
                }
            }
            
            // テーブル作成.
            return createTable.getTable() ;
            
        } catch( Exception e ) {
            throw new RimDbException( "指定ファイル[" + fileName + "]のテーブル作成中にエラーが発生しました",e ) ;
        }
    }
    
}

