package org.maachang.rimdb.index.number32 ;

import org.maachang.rimdb.index.IfPointer;

/**
 * Number32(int)大なり(>)ポインタ.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class Number32Big extends IfPointer<Integer> {
    protected Number32Big(){}
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param eq [>=]で検索する場合は[true]をセット.
     */
    public Number32Big( Number32Index index,boolean eq ) {
        if( eq ) {
            this.type = TYPE_BIG_EQ ;
        }
        else {
            this.type = TYPE_BIG ;
        }
        this.columnName = index.getColumnName() ;
        this.eq = eq ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param eq [>=]で検索する場合は[true]をセット.
     * @param word 対象の検索ワードを設定します.
     */
    public Number32Big( Number32Index index,boolean eq,int word ) {
        this( index,eq ) ;
        set( word ) ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param eq [>=]で検索する場合は[true]をセット.
     * @param word 対象の検索ワードを設定します.
     */
    public Number32Big( Number32Index index,boolean eq,Object word ) {
        this( index,eq ) ;
        parameter( word ) ;
    }
    
    /**
     * 情報セット.
     * @param word 対象の検索ワードを設定します.
     */
    public final void parameter( final Object word ) {
        set( Number32In.convert( word ) ) ;
    }
    
    /**
     * オブジェクトコピー.
     * @param mode [true]を設定した場合、パラメータ情報はコピーされません.
     * @return SearchPointer コピーされたオブジェクトが返却されます.
     */
    public final Number32Big copy( final boolean mode ) {
        Number32Big ret = new Number32Big() ;
        baseCopy( mode,ret ) ;
        return ret ;
    }
}
