package org.maachang.rimdb.index.number32 ;

import org.maachang.rimdb.index.BetweenPointer;

/**
 * Number32(int)一致ポインタ.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class Number32Between extends BetweenPointer<Integer> {
    protected Number32Between(){}
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param start 対象の開始検索ワードを設定します.
     * @param end 対象の終了検索ワードを設定します.
     */
    public Number32Between( Number32Index index ) {
        this.type = TYPE_BETWEEN ;
        this.columnName = index.getColumnName() ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param start 対象の開始検索ワードを設定します.
     * @param end 対象の終了検索ワードを設定します.
     */
    public Number32Between( Number32Index index,int start,int end ) {
        this( index ) ;
        set( start,end ) ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param start 対象の開始検索ワードを設定します.
     * @param end 対象の終了検索ワードを設定します.
     */
    public Number32Between( Number32Index index,Object start,Object end ) {
        this( index ) ;
        parameter( start,end ) ;
    }
    
    /**
     * 情報セット.
     * @param start 対象の開始検索ワードを設定します.
     * @param end 対象の終了検索ワードを設定します.
     */
    public final void parameter( final Object start,final Object end ) {
        set( Number32In.convert( start ),Number32In.convert( end ) ) ;
    }
    
    /**
     * オブジェクトコピー.
     * @param mode [true]を設定した場合、パラメータ情報はコピーされません.
     * @return SearchPointer コピーされたオブジェクトが返却されます.
     */
    public final Number32Between copy( final boolean mode ) {
        Number32Between ret = new Number32Between() ;
        baseCopy( mode,ret ) ;
        return ret ;
    }
}
