package org.maachang.rimdb.index.number32 ;

import org.maachang.rimdb.index.CreateIndex;
import org.maachang.rimdb.util.OList;

/**
 * Number32インデックス作成オブジェクト
 * 
 * @version 2014/07/04
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class CreateNumber32Index extends CreateIndex<Integer,Number32Index> {
    
    /**
     * コンストラクタ.
     */
    public CreateNumber32Index() {
        list = new OList<Integer>() ;
    }
    
    /**
     * インデックス行情報をセット.
     * @param array インデックスに追加する配列オブジェクトを設定します.
     */
    public void addArray( Integer[] array ) {
        if( list.size() == 0 ) {
            list.setAll( array ) ;
        }
        else {
            final int len = array.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                list.add( array[ i ]  ) ;
            }
        }
    }
    
    /**
     * インデックス行情報をセット.
     * @param array インデックスに追加する配列オブジェクトを設定します.
     */
    public void addArray( int[] array ) {
        if( list.size() == 0 ) {
            list.setAll( array ) ;
        }
        else {
            final int len = array.length ;
            for( int i = 0 ; i < len ; i ++ ) {
                list.add( array[ i ]  ) ;
            }
        }
    }
    
    /**
     * 配列生成.
     * @param length 配列生成サイズを設定します.
     * @return Object 生成された配列が返却されます.
     */
    protected final Object create( final int length ) {
        return new int[ length ] ;
    }
    
    /**
     * 配列セット.
     * @param index 対象のインデックスを設定します.
     * @param no 対象の項番を設定します.
     * @param value 対象の条件を設定します.
     */
    protected final void set( final Object index,final int no,final Object value ) {
        ((int[])index)[ no ] = (Integer)value ;
    }
    
    /**
     * インデックス変換.
     * @param index 対象のインデックスを設定します.
     * @param lines 対象の行インデックスを設定します.
     * @param max 全件数を設定します.
     * @return Number32Index 生成されたインデックスオブジェクトが返却されます.
     */
    protected final Number32Index convert( final Object index,final int[][] lines,final int max ) {
        return new Number32Index( (int[])index,lines,max ) ;
    }
    
}
