package org.maachang.rimdb.index.comparable ;

import org.maachang.rimdb.index.BetweenPointer;

/**
 * Comparable(比較可能なJavaオブジェクト)一致ポインタ.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
@SuppressWarnings("unchecked")
public final class ComparableBetween extends BetweenPointer<Comparable> {
    protected ComparableBetween(){}
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     */
    public ComparableBetween( ComparableIndex index ) {
        this.type = TYPE_BETWEEN ;
        this.columnName = index.getColumnName() ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param start 対象の開始検索ワードを設定します.
     * @param end 対象の終了検索ワードを設定します.
     */
    public ComparableBetween( ComparableIndex index,Comparable start,Comparable end ) {
        this( index ) ;
        set( start,end ) ;
    }
    
    /**
     * コンストラクタ.
     * @param index 対象のインデックスを設定します.
     * @param start 対象の開始検索ワードを設定します.
     * @param end 対象の終了検索ワードを設定します.
     */
    public ComparableBetween( ComparableIndex index,Object start,Object end ) {
        this( index ) ;
        parameter( start,end ) ;
    }
    
    /**
     * 情報セット.
     * @param start 対象の開始ワード情報を設定します.
     * @param end 対象の終了ワード情報を設定します.
     */
    public final void parameter( final Object start,final Object end ) {
        set( ComparableIn.convert( start ),ComparableIn.convert( start ) ) ;
    }
    
    /**
     * オブジェクトコピー.
     * @param mode [true]を設定した場合、パラメータ情報はコピーされません.
     * @return SearchPointer コピーされたオブジェクトが返却されます.
     */
    public final ComparableBetween copy( final boolean mode ) {
        ComparableBetween ret = new ComparableBetween() ;
        baseCopy( mode,ret ) ;
        return ret ;
    }
}
