package org.maachang.rimdb.index ;

/**
 * 配列ソート用オブジェクト.
 * 
 * @version 2014/07/07
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
@SuppressWarnings("unchecked")
public final class SortArray<T> implements Comparable<T> {
    
    /** 要素. **/
    public T n ;
    
    /** 行位置. **/
    public int line ;
    
    /**
     * コンストラクタ.
     * @param n 対象の要素を設定します.
     * @param line 対象の行位置を設定します.
     */
    public SortArray( T n,int line ) {
        this.n = n ;
        this.line = line ;
    }
    
    /**
     * 判別処理.
     * @param x 対象の条件を設定します.
     * @return int [1]の場合はこのオブジェクトの条件の方が大きい.
     *             [-1]の場合は、このオブジェクトの条件の方が小さい.
     *             [0]の場合は、等しい.
     */
    public final int compareTo( T x ) {
        return ((Comparable)n).compareTo( ((SortArray)x).n ) ;
    }
}

