package org.maachang.rimdb.index ;

/**
 * Mask情報.
 * 
 * @version 2014/06/29
 * @author  masahito suzuki
 * @since   rimdb-1.00
 */
public final class Mask {
    /** マスク要素. **/
    public int value ;
    
    /** コンストラクタ. **/
    public Mask() {
        value = 0 ;
    }
    
    /**
     * コンストラクタ.
     * @param v マスク要素を設定します.
     */
    public Mask( final int v ) {
        value = v ;
    }
    
    /**
     * マスク要素を取得.
     * @return int マスク要素が返却されます.
     */
    public final int get() {
        return value ;
    }
    
    /**
     * マスク要素を設定.
     * @param v マスク要素を設定します.
     */
    public final void set( final int v ) {
        value = v ;
    }
}

