/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.util;

import java.util.Arrays;
import org.maachang.rimdb.util.NAdd;

public final class NList
implements NAdd {
    private static final int DEF = 16;
    public int[] list;
    public int length;
    private int max;

    public NList() {
        this(16);
    }

    public NList(int buf) {
        if (buf < 16) {
            buf = 16;
        }
        this.max = buf;
        this.list = new int[buf];
        this.length = 0;
    }

    public NList(int[] n) {
        this.list = n;
        this.max = this.length = n.length;
    }

    @Override
    public final void clear() {
        if (this.list.length != this.max) {
            this.list = new int[this.max];
        }
        this.length = 0;
    }

    @Override
    public final void clear(int buf) {
        if (this.list.length < buf) {
            this.list = new int[buf];
        }
        this.length = 0;
    }

    @Override
    public final void add(int n) {
        if (this.length + 1 >= this.list.length) {
            int[] tmp = new int[this.length << 1];
            System.arraycopy(this.list, 0, tmp, 0, this.length);
            this.list = tmp;
        }
        this.list[this.length++] = n;
    }

    public final void set(int no, int n) {
        this.list[no] = n;
    }

    public final int get(int no) {
        return this.list[no];
    }

    public final void remove(int no) {
        if (this.length > 1) {
            --this.length;
            while (no < this.length) {
                this.list[no++] = this.list[no];
            }
        } else {
            this.length = 0;
        }
    }

    @Override
    public final int size() {
        return this.length;
    }

    public final NList sort() {
        if (this.length > 0) {
            Arrays.sort(this.list, 0, this.length);
        }
        return this;
    }

    @Override
    public final int[] getArray() {
        int[] ret = new int[this.length];
        System.arraycopy(this.list, 0, ret, 0, this.length);
        return ret;
    }

    @Override
    public final int[] toArray() {
        return this.list;
    }

    public final void setAll(int[] n) {
        this.list = n;
        this.max = this.length = n.length;
    }
}

