/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.util;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.maachang.rimdb.util.ConvertUtil;
import org.maachang.rimdb.util.FileUtil;
import org.maachang.rimdb.util.OList;
import org.maachang.rimdb.util.OOKeyValue;
import org.maachang.rimdb.util.ReadIni;

public class Config {
    private OOKeyValue<String, OOKeyValue<String, OList<Object>>> params = new OOKeyValue();
    private OOKeyValue<String, OList<Object>> keyByNum = new OOKeyValue();
    private String srcName = null;

    public static final boolean read(Config conf, String name) throws Exception {
        if (!FileUtil.isFile(name)) {
            throw new IOException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + name + "]\u306f\u5b58\u5728\u3057\u306a\u3044\u304b\u3001\u8aad\u307f\u8fbc\u3081\u307e\u305b\u3093");
        }
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(name), "UTF8"));
            ReadIni.analisys(conf, br);
            conf.srcName = FileUtil.getFullPath(name);
            br.close();
            br = null;
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (Exception exception) {}
            }
        }
        return true;
    }

    public static final Config read(String name) throws Exception {
        Config ret = new Config();
        Config.read(ret, name);
        return ret;
    }

    public void clear() {
        this.params.clear();
        this.keyByNum.clear();
        this.srcName = null;
    }

    public void put(String section, String key, String value) {
        OList<Object> keyValue;
        if (section == null || key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        section = section.trim();
        key = key.trim();
        OList<Object> keys = this.keyByNum.get(section);
        OOKeyValue<String, OList<Object>> sectionValue = this.params.get(section);
        if (sectionValue == null) {
            sectionValue = new OOKeyValue();
            this.params.put(section, sectionValue);
            keys = new OList();
            this.keyByNum.put(section, keys);
        }
        if ((keyValue = sectionValue.get(key)) == null) {
            keyValue = new OList();
            sectionValue.put(key, keyValue);
            keys.add(key);
        }
        keyValue.add(value);
    }

    public void set(String section, String key, String value) {
        OList<Object> keyValue;
        if (section == null || key == null) {
            return;
        }
        if (value == null) {
            value = "";
        }
        section = section.trim();
        key = key.trim();
        OOKeyValue<String, OList<Object>> sectionValue = this.params.get(section);
        if (sectionValue == null) {
            sectionValue = new OOKeyValue();
            this.params.put(section, sectionValue);
        }
        if ((keyValue = sectionValue.get(key)) == null) {
            keyValue = new OList();
            sectionValue.put(key, keyValue);
        } else {
            keyValue.clear();
        }
        keyValue.add(value);
    }

    public String get(String section, String key, int no) {
        OList<Object> value;
        if (section == null || key == null || no < 0) {
            return null;
        }
        section = section.trim();
        key = key.trim();
        OOKeyValue<String, OList<Object>> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null && value.size() > no) {
            return (String)value.get(no);
        }
        return null;
    }

    public Boolean getBoolean(String section, String key, int no) {
        try {
            return ConvertUtil.convertBool(this.get(section, key, no));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Integer getInt(String section, String key, int no) {
        try {
            return ConvertUtil.convertInt(this.get(section, key, no));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Long getLong(String section, String key, int no) {
        try {
            return ConvertUtil.convertLong(this.get(section, key, no));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Double getDouble(String section, String key, int no) {
        try {
            return ConvertUtil.convertDouble(this.get(section, key, no));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getString(String section, String key, int no) {
        try {
            return ConvertUtil.convertString(this.get(section, key, no));
        }
        catch (Exception e) {
            return null;
        }
    }

    public java.sql.Date getSqlDate(String section, String key, int no) {
        try {
            return ConvertUtil.convertSqlDate(this.get(section, key, no));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Time getSqlTime(String section, String key, int no) {
        try {
            return ConvertUtil.convertSqlTime(this.get(section, key, no));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Timestamp getSqlTimestamp(String section, String key, int no) {
        try {
            return ConvertUtil.convertSqlTimestamp(this.get(section, key, no));
        }
        catch (Exception e) {
            return null;
        }
    }

    public Date getDate(String section, String key, int no) {
        try {
            return ConvertUtil.convertSqlTimestamp(this.get(section, key, no));
        }
        catch (Exception e) {
            return null;
        }
    }

    public String[] getAll(String section, String key) {
        OList<Object> value;
        if (section == null || key == null) {
            return null;
        }
        section = section.trim();
        key = key.trim();
        OOKeyValue<String, OList<Object>> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null && value.size() > 0) {
            int len = value.size();
            String[] ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)value.get(i);
                ++i;
            }
            return ret;
        }
        return null;
    }

    public void removeSection(String section) {
        if (section == null) {
            return;
        }
        this.params.remove(section);
        this.keyByNum.remove(section);
    }

    public void removeKey(String section, String key) {
        if (section == null || key == null) {
            return;
        }
        section = section.trim();
        key = key.trim();
        OOKeyValue<String, OList<Object>> sectionValue = this.params.get(section);
        if (sectionValue != null) {
            sectionValue.remove(key);
            OList<Object> keys = this.keyByNum.get(section);
            if (keys != null && keys.size() > 0) {
                int len = keys.size();
                int i = 0;
                while (i < len) {
                    if (key.equals(keys.get(i))) {
                        keys.remove(i);
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    public int size(String section, String key) {
        OList<Object> value;
        if (section == null || key == null) {
            return -1;
        }
        section = section.trim();
        key = key.trim();
        OOKeyValue<String, OList<Object>> sectionValue = this.params.get(section);
        if (sectionValue != null && (value = sectionValue.get(key)) != null) {
            return value.size();
        }
        return -1;
    }

    public int size(String section) {
        if (section == null) {
            return -1;
        }
        OOKeyValue<String, OList<Object>> sectionValue = this.params.get(section = section.trim());
        if (sectionValue != null) {
            return sectionValue.size();
        }
        return 0;
    }

    public int size() {
        return this.params.size();
    }

    public String[] getKeys(String section) {
        if (section == null) {
            return null;
        }
        section = section.trim();
        OList<Object> keys = this.keyByNum.get(section);
        String[] ret = null;
        if (keys != null && keys.size() > 0) {
            int len = keys.size();
            ret = new String[len];
            int i = 0;
            while (i < len) {
                ret[i] = (String)keys.get(i);
                ++i;
            }
        }
        return ret;
    }

    public Object[] getSections() {
        if (this.params != null && this.params.size() > 0) {
            return this.params.keyArray();
        }
        return null;
    }

    public boolean isKeys(String section, String key) {
        if (section == null) {
            return false;
        }
        OOKeyValue<String, OList<Object>> sectionValue = this.params.get(section = section.trim());
        if (sectionValue != null) {
            return sectionValue.get(key) != null;
        }
        return false;
    }

    public boolean isSection(String section) {
        if (section == null) {
            return false;
        }
        return this.params.containsKey(section.trim());
    }

    public Config getSectionByConfig(String section) {
        if (section == null) {
            return null;
        }
        if (!this.params.containsKey(section = section.trim())) {
            return null;
        }
        OOKeyValue<String, OList<Object>> n = this.params.get(section);
        Config ret = new Config();
        OOKeyValue<String, OList<Object>> nn = n.reset();
        while (nn.hasNext()) {
            String key = nn.next();
            OList<Object> lst = n.get(key);
            int len = lst.size();
            int i = 0;
            while (i < len) {
                ret.put(section, key, (String)lst.get(i));
                ++i;
            }
        }
        return ret;
    }

    public String getSrcName() {
        return this.srcName;
    }

    public String toString() {
        if (this.params != null && this.params.size() > 0) {
            StringBuilder buf = new StringBuilder();
            Object[] objs = this.params.keyArray();
            int len = objs.length;
            int i = 0;
            while (i < len) {
                buf.append("[").append(objs[i]).append("]\n");
                OOKeyValue<String, OList<Object>> key = this.params.get((String)objs[i]);
                if (key != null && key.size() > 0) {
                    Object[] sObjs = key.keyArray();
                    int lenJ = sObjs.length;
                    int j = 0;
                    while (j < lenJ) {
                        buf.append("  ").append(sObjs[j]).append("\n");
                        OList<Object> emt = key.get((String)sObjs[j]);
                        if (emt != null && emt.size() > 0) {
                            int lenK = emt.size();
                            buf.append("    ");
                            int k = 0;
                            while (k < lenK) {
                                if (k != 0) {
                                    buf.append(",");
                                }
                                buf.append(emt.get(k));
                                ++k;
                            }
                            buf.append("\n");
                        }
                        ++j;
                    }
                }
                ++i;
            }
            return buf.toString();
        }
        return "null";
    }
}

