/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table.array;

import java.util.Arrays;
import java.util.HashSet;
import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.index.SortArray;

public final class UniqueId {
    protected final boolean intFlag;
    protected final long[] longList;
    protected final int[] intList;
    protected final int[] lines;

    public UniqueId(Integer[] columns) {
        int len = columns.length;
        HashSet<Integer> set = new HashSet<Integer>();
        int i = 0;
        while (i < len) {
            Integer n = columns[i];
            if (n == null) {
                throw new RimDbException("[null]\u3092\u542b\u3080\u5185\u5bb9\u306f\u3001ID\u914d\u5217\u306b\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            if (set.contains(n)) {
                throw new RimDbException("\u91cd\u8907\u6761\u4ef6\u3092\u542b\u3080\u5185\u5bb9\u306f\u3001ID\u914d\u5217\u306b\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            set.add(n);
            ++i;
        }
        set.clear();
        set = null;
        Object[] list = new SortArray[len];
        i = 0;
        while (i < len) {
            list[i] = new SortArray<Integer>(columns[i], i);
            ++i;
        }
        Arrays.sort(list);
        int[] nn = new int[len];
        int[] ln = new int[len];
        i = 0;
        while (i < len) {
            nn[i] = (Integer)((SortArray)list[i]).n;
            ln[i] = ((SortArray)list[i]).line;
            ++i;
        }
        this.intFlag = true;
        this.longList = null;
        this.intList = nn;
        this.lines = ln;
    }

    public UniqueId(Long[] columns) {
        int len = columns.length;
        HashSet<Long> set = new HashSet<Long>();
        boolean flg = true;
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        int i = 0;
        while (i < len) {
            Long n = columns[i];
            if (n == null) {
                throw new RimDbException("[null]\u3092\u542b\u3080\u5185\u5bb9\u306f\u3001ID\u914d\u5217\u306b\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            if (set.contains(n)) {
                throw new RimDbException("\u91cd\u8907\u6761\u4ef6\u3092\u542b\u3080\u5185\u5bb9\u306f\u3001ID\u914d\u5217\u306b\u306f\u3067\u304d\u307e\u305b\u3093");
            }
            set.add(n);
            if (n < (long)min || n > (long)max) {
                flg = false;
            }
            ++i;
        }
        set.clear();
        set = null;
        if (flg) {
            Object[] list = new SortArray[len];
            i = 0;
            while (i < len) {
                list[i] = new SortArray<Integer>(columns[i].intValue(), i);
                ++i;
            }
            Arrays.sort(list);
            int[] nn = new int[len];
            int[] ln = new int[len];
            i = 0;
            while (i < len) {
                nn[i] = (Integer)((SortArray)list[i]).n;
                ln[i] = ((SortArray)list[i]).line;
                ++i;
            }
            this.intFlag = flg;
            this.longList = null;
            this.intList = nn;
            this.lines = ln;
        } else {
            Object[] list = new SortArray[len];
            i = 0;
            while (i < len) {
                list[i] = new SortArray<Long>(columns[i], i);
                ++i;
            }
            Arrays.sort(list);
            long[] nn = new long[len];
            int[] ln = new int[len];
            i = 0;
            while (i < len) {
                nn[i] = (Long)((SortArray)list[i]).n;
                ln[i] = ((SortArray)list[i]).line;
                ++i;
            }
            this.intFlag = flg;
            this.longList = nn;
            this.intList = null;
            this.lines = ln;
        }
    }

    public final long get(int no) {
        return this.intFlag ? (long)this.intList[no] : this.longList[no];
    }

    public final int getLine(int no) {
        return this.lines[no];
    }

    public final int search(int id) {
        int no;
        if (this.intFlag ? (no = IndexUtil.searchInt(this.intList, id)) == -1 : (no = IndexUtil.searchLong(this.longList, id)) == -1) {
            return -1;
        }
        return this.lines[no];
    }

    public final int search(long id) {
        int no;
        if (this.intFlag ? (no = IndexUtil.searchInt(this.intList, (int)id)) == -1 : (no = IndexUtil.searchLong(this.longList, id)) == -1) {
            return -1;
        }
        return this.lines[no];
    }
}

