/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table.array;

import java.sql.Time;
import java.util.Date;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.table.array.ColumnArray;
import org.maachang.rimdb.util.NList;

public final class TimeArray
implements ColumnArray<Time> {
    private int[] list;
    private int[] nullList;

    public TimeArray(Date[] columns) {
        NList nulls = new NList();
        int len = columns.length;
        int[] n = new int[len];
        int i = 0;
        while (i < len) {
            if (columns[i] == null) {
                nulls.add(i);
            } else {
                Date t = columns[i];
                n[i] = (int)new Time(t.getHours(), t.getMinutes(), t.getSeconds()).getTime();
            }
            ++i;
        }
        this.list = n;
        this.nullList = (int[])(nulls.size() == 0 ? null : nulls.sort().getArray());
    }

    public TimeArray(Time[] columns) {
        NList nulls = new NList();
        int len = columns.length;
        int[] n = new int[len];
        int i = 0;
        while (i < len) {
            if (columns[i] == null) {
                nulls.add(i);
            } else {
                Time t = columns[i];
                n[i] = (int)new Time(t.getHours(), t.getMinutes(), t.getSeconds()).getTime();
            }
            ++i;
        }
        this.list = n;
        this.nullList = (int[])(nulls.size() == 0 ? null : nulls.sort().getArray());
    }

    @Override
    public final int getType() {
        return 6;
    }

    @Override
    public final Time get(int no) {
        if (this.nullList != null && IndexUtil.searchInt(this.nullList, no) != -1) {
            return null;
        }
        return new Time(this.list[no]);
    }

    public final Time get(Time out, int no) {
        if (this.nullList != null && IndexUtil.searchInt(this.nullList, no) != -1) {
            return null;
        }
        out.setTime(this.list[no]);
        return out;
    }
}

