/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table.array;

import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.table.array.ColumnArray;
import org.maachang.rimdb.util.NList;
import org.maachang.rimdb.util.OList;

public final class StringArray
implements ColumnArray<String> {
    private char[] list;
    private int[] posList;
    private int[] nullList;

    public StringArray(String[] columns) {
        char[] c;
        NList nulls = new NList();
        OList<char[]> n = new OList<char[]>();
        int len = columns.length;
        int cnt = 0;
        int i = 0;
        while (i < len) {
            if (columns[i] == null) {
                nulls.add(i);
                n.add(null);
            } else {
                c = columns[i].toCharArray();
                cnt += c.length;
                n.add(c);
            }
            ++i;
        }
        int nLen = n.size();
        char[] cc = new char[cnt];
        int[] plst = new int[nLen + 1];
        cnt = 0;
        plst[0] = 0;
        i = 0;
        while (i < len) {
            c = (char[])n.get(i);
            if (c != null) {
                System.arraycopy(c, 0, cc, cnt, c.length);
                cnt += c.length;
            }
            plst[i + 1] = cnt;
            ++i;
        }
        n.clear();
        this.list = cc;
        this.posList = plst;
        this.nullList = (int[])(nulls.size() == 0 ? null : nulls.sort().getArray());
    }

    @Override
    public final int getType() {
        return 8;
    }

    @Override
    public final String get(int no) {
        if (this.nullList != null && IndexUtil.searchInt(this.nullList, no) != -1) {
            return null;
        }
        int n = this.posList[no];
        return new String(this.list, n, this.posList[no + 1] - n);
    }
}

