/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.maachang.rimdb.table.TableImpl;
import org.maachang.rimdb.table.TableUtil;

public final class TableManager {
    private final Map<String, TableImpl> map = new ConcurrentHashMap<String, TableImpl>();

    public final void reset() {
        Iterator<String> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            this.map.get((Object)it.next()).row.clear();
        }
    }

    public final void set(TableImpl table) {
        this.map.put(table.getName(), table);
    }

    public final TableImpl get(String name) {
        return this.map.get(TableUtil.convertJavaNameByDBName(name));
    }

    public final int size() {
        return this.map.size();
    }

    public final String[] getNames() {
        int cnt = 0;
        Object[] ret = new String[this.map.size()];
        Iterator<String> it = this.map.keySet().iterator();
        while (it.hasNext()) {
            ret[cnt++] = it.next();
        }
        Arrays.sort(ret);
        return ret;
    }
}

