/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table;

import org.maachang.rimdb.Table;
import org.maachang.rimdb.table.Columns;
import org.maachang.rimdb.table.Indexs;
import org.maachang.rimdb.table.RowImpl;
import org.maachang.rimdb.table.Uniques;

public final class TableImpl
implements Table {
    protected final Columns columns;
    protected final Uniques uniques;
    protected final Indexs indexs;
    protected final RowImpl row;
    protected final String name;
    protected final int length;

    public TableImpl(Columns columns, Uniques uniques, Indexs indexs, String name, int length) {
        this.columns = columns;
        this.uniques = uniques;
        this.indexs = indexs;
        this.row = new RowImpl(columns, indexs.positionColumns);
        this.name = name;
        this.length = length;
    }

    @Override
    public final void reset() {
        this.row.clear();
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int length() {
        return this.length;
    }

    public final Columns getColumns() {
        return this.columns;
    }

    public final Uniques getUniques() {
        return this.uniques;
    }

    public final Indexs getIndexs() {
        return this.indexs;
    }

    @Override
    public final int getColumnLength() {
        return this.columns.length;
    }

    @Override
    public final String getColumnName(int no) {
        return this.columns.columnNames[no];
    }

    @Override
    public final RowImpl getRow() {
        this.row.clear();
        return this.row;
    }

    @Override
    public final RowImpl getRow(int no) {
        this.row.position(no);
        return this.row;
    }

    @Override
    public final boolean isUnique(int no) {
        return this.uniques.contains(no);
    }

    @Override
    public final boolean isUnique(String name) {
        int p = this.columns.getColumnNo(name);
        if (p == -1) {
            return false;
        }
        return this.uniques.contains(p);
    }

    @Override
    public final int search(int value) {
        return this.search(0, value);
    }

    @Override
    public final int search(long value) {
        return this.search(0, value);
    }

    @Override
    public final RowImpl searchRow(int value) {
        return this.searchRow(0, value);
    }

    @Override
    public final RowImpl searchRow(long value) {
        return this.searchRow(0, value);
    }

    @Override
    public final int search(int no, int value) {
        return this.uniques.search(no, value);
    }

    @Override
    public final int search(int no, long value) {
        return this.uniques.search(no, value);
    }

    @Override
    public final int search(String name, int value) {
        int p = this.columns.getColumnNo(name);
        if (p == -1) {
            return -1;
        }
        return this.uniques.search(p, value);
    }

    @Override
    public final int search(String name, long value) {
        int p = this.columns.getColumnNo(name);
        if (p == -1) {
            return -1;
        }
        return this.uniques.search(p, value);
    }

    @Override
    public final RowImpl searchRow(int no, int value) {
        int p = this.uniques.search(no, value);
        if (p == -1) {
            return null;
        }
        return this.getRow(p);
    }

    @Override
    public final RowImpl searchRow(int no, long value) {
        int p = this.uniques.search(no, value);
        if (p == -1) {
            return null;
        }
        return this.getRow(p);
    }

    @Override
    public final RowImpl searchRow(String name, int value) {
        int p = this.columns.getColumnNo(name);
        if (p == -1 || (p = this.uniques.search(p, value)) == -1) {
            return null;
        }
        return this.getRow(p);
    }

    @Override
    public final RowImpl searchRow(String name, long value) {
        int p = this.columns.getColumnNo(name);
        if (p == -1 || (p = this.uniques.search(p, value)) == -1) {
            return null;
        }
        return this.getRow(p);
    }
}

