/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.util.Properties;
import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.table.LoadTable;
import org.maachang.rimdb.table.TableImpl;
import org.maachang.rimdb.table.TableUtil;

public final class JDBCTable
extends LoadTable {
    private static final int FETCH_SIZE = 100;
    private String driver;
    private String url;
    private String user;
    private String passwd;
    private String sql;

    public JDBCTable(String driver, String url, String sql) {
        this(driver, url, null, null, sql);
    }

    public JDBCTable(String driver, String url, String user, String passwd, String sql) {
        this.driver = driver;
        this.url = url;
        this.user = user;
        this.passwd = passwd;
        this.sql = sql;
    }

    @Override
    public final TableImpl create() {
        if (this.createTable == null) {
            throw new RimDbException("\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u304c\u884c\u308f\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        Statement st = null;
        ResultSet rs = null;
        Connection conn = null;
        ResultSetMetaData meta = null;
        try {
            conn = JDBCTable.driverConnection(this.driver, this.url, this.user, this.passwd);
            st = conn.createStatement(1003, 1007);
            st.setFetchSize(100);
            rs = st.executeQuery(this.sql);
            rs.setFetchSize(100);
            meta = rs.getMetaData();
            int cnt = 1;
            int jdbcColumnLen = meta.getColumnCount();
            int[] jdbcColumnTypes = new int[jdbcColumnLen];
            String[] jdbcColumns = new String[jdbcColumnLen];
            int i = 0;
            while (i < jdbcColumnLen) {
                jdbcColumns[i] = meta.getColumnName(cnt).toLowerCase();
                jdbcColumnTypes[i] = JDBCTable.getDBType(jdbcColumns[i], meta.getColumnType(cnt));
                ++cnt;
                ++i;
            }
            int[] columnNoList = TableUtil.headerColumnByNoList(this.createTable.getColumns(), jdbcColumns);
            jdbcColumns = null;
            while (rs.next()) {
                this.createTable.next();
                i = 0;
                while (i < jdbcColumnLen) {
                    this.createTable.set(columnNoList[i], JDBCTable.getDBTypeByValue(rs, jdbcColumnTypes[i], i + 1));
                    ++i;
                }
            }
            conn.commit();
            meta = null;
            rs.close();
            rs = null;
            st.close();
            st = null;
            conn.close();
            conn = null;
            TableImpl tableImpl = this.createTable.getTable();
            return tableImpl;
        }
        catch (Exception e) {
            throw new RimDbException("\u6307\u5b9aJDBC[driver:" + this.driver + " url:" + this.url + " sql:" + this.sql + "]\u306e\u30c6\u30fc\u30d6\u30eb\u4f5c\u6210\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (Exception exception) {}
            }
            if (st != null) {
                try {
                    st.close();
                }
                catch (Exception exception) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    private static final Connection driverConnection(String driver, String url, String user, String passwd) throws Exception {
        Connection ret;
        Class.forName(driver);
        Properties p = new Properties();
        if (user == null || user.length() <= 0) {
            p.put("user", "");
            p.put("password", "");
            ret = DriverManager.getConnection(url, p);
        } else {
            p.put("user", user);
            p.put("password", passwd);
            ret = DriverManager.getConnection(url, p);
        }
        ret.setReadOnly(false);
        ret.setAutoCommit(false);
        return ret;
    }

    private static final int getDBType(String columnName, int columnType) {
        switch (columnType) {
            case -7: 
            case -6: {
                return 1;
            }
            case 16: {
                return 2;
            }
            case 5: {
                return 3;
            }
            case -5: 
            case 4: {
                return 4;
            }
            case 6: 
            case 7: {
                return 5;
            }
            case 8: {
                return 6;
            }
            case 2: 
            case 3: {
                return 7;
            }
            case -1: 
            case 1: 
            case 12: 
            case 70: {
                return 8;
            }
            case 91: {
                return 9;
            }
            case 92: {
                return 10;
            }
            case 93: {
                return 11;
            }
        }
        throw new RimDbException("\u5bfe\u8c61\u30ab\u30e9\u30e0[" + columnName + "]\u306e\u5f62\u5f0f\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093[" + columnType + "]");
    }

    private static final Object getDBTypeByValue(ResultSet rs, int type, int no) throws Exception {
        if (rs.getObject(no) == null) {
            return null;
        }
        switch (type) {
            case 1: {
                return rs.getInt(no);
            }
            case 2: {
                return rs.getBoolean(no);
            }
            case 3: {
                return rs.getInt(no);
            }
            case 4: {
                return rs.getLong(no);
            }
            case 5: {
                return Float.valueOf(rs.getFloat(no));
            }
            case 6: {
                return rs.getDouble(no);
            }
            case 7: {
                return rs.getBigDecimal(no);
            }
            case 8: {
                return rs.getString(no);
            }
            case 9: {
                return rs.getDate(no);
            }
            case 10: {
                return rs.getTime(no);
            }
            case 11: {
                return rs.getTimestamp(no);
            }
        }
        return null;
    }
}

