/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.table.LoadTable;
import org.maachang.rimdb.table.TableImpl;
import org.maachang.rimdb.table.TableUtil;
import org.maachang.rimdb.util.CsvReader;

public final class CsvTable
extends LoadTable {
    protected String fileName;
    protected String charset;
    protected boolean headerFlag;

    public CsvTable(boolean header, String name) {
        this(header, null, name);
    }

    public CsvTable(boolean header, String charset, String name) {
        if (charset == null) {
            charset = "Windows-31J";
        }
        this.fileName = name;
        this.charset = charset;
        this.headerFlag = header;
    }

    @Override
    public final TableImpl create() {
        if (this.createTable == null) {
            throw new RimDbException("\u30c6\u30fc\u30d6\u30eb\u5b9a\u7fa9\u304c\u884c\u308f\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        try {
            int i;
            int len;
            int[] columnNoList;
            String[] list;
            String[] columns = this.createTable.getColumns();
            CsvReader reader = new CsvReader(this.fileName, this.charset, ",");
            if (this.headerFlag) {
                if (!reader.next()) {
                    throw new RimDbException("\u30d8\u30c3\u30c0\u60c5\u5831\u306f\u5b58\u5728\u3057\u307e\u305b\u3093");
                }
                list = reader.getArray();
                columnNoList = TableUtil.headerColumnByNoList(columns, list);
                len = columnNoList.length;
            } else {
                len = columns.length;
                columnNoList = new int[len];
                i = 0;
                while (i < len) {
                    columnNoList[i] = i;
                    ++i;
                }
            }
            while (reader.next()) {
                list = reader.getArray();
                if (list == null || list.length != len) continue;
                this.createTable.next();
                i = 0;
                while (i < len) {
                    this.createTable.set(columnNoList[i], (Object)list[i]);
                    ++i;
                }
            }
            return this.createTable.getTable();
        }
        catch (Exception e) {
            throw new RimDbException("\u6307\u5b9a\u30d5\u30a1\u30a4\u30eb[" + this.fileName + "]\u306e\u30c6\u30fc\u30d6\u30eb\u4f5c\u6210\u4e2d\u306b\u30a8\u30e9\u30fc\u304c\u767a\u751f\u3057\u307e\u3057\u305f", e);
        }
    }
}

