/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.Row;
import org.maachang.rimdb.index.position.PositionIndex;
import org.maachang.rimdb.table.Columns;
import org.maachang.rimdb.util.ConvertUtil;
import org.maachang.rimdb.util.NOChild;
import org.maachang.rimdb.util.NOKeyValue;

final class CopyRow
implements Row {
    protected final Columns columns;
    protected final int[] positionColumns;
    protected final int position;
    private NOKeyValue<Object> newInfo;

    protected CopyRow(Columns columns, int[] positionColumns, int position) {
        this.columns = columns;
        this.positionColumns = positionColumns;
        this.position = position;
    }

    @Override
    public final void clear() {
        this.newInfo = null;
    }

    @Override
    public final Row copy() {
        CopyRow ret = new CopyRow(this.columns, this.positionColumns, this.position);
        if (this.newInfo != null) {
            this.newInfo.reset();
            while (this.newInfo.hasNext()) {
                NOChild<Object> ch = this.newInfo.nextChild();
                ret.put(ch.getKey(), ch.getValue());
            }
        }
        return ret;
    }

    @Override
    public final int position() {
        return this.position;
    }

    @Override
    public final int getType(int no) {
        return this.columns.getType(no);
    }

    @Override
    public final int getType(String name) {
        return this.columns.getType(name);
    }

    @Override
    public final int length() {
        return this.columns.length;
    }

    @Override
    public final String getColumnName(int no) {
        return this.columns.columnNames[no];
    }

    @Override
    public final Object getValue(int no) {
        if (this.newInfo == null) {
            return this.columns.list[no].get(this.position);
        }
        NOChild<Object> ret = this.newInfo.getChild(no);
        if (ret == null) {
            return this.columns.list[no].get(this.position);
        }
        return ret.getValue();
    }

    @Override
    public final Object getValue(long no) {
        if (this.newInfo == null) {
            return this.columns.list[(int)no].get(this.position);
        }
        NOChild<Object> ret = this.newInfo.getChild((int)no);
        if (ret == null) {
            return this.columns.list[(int)no].get(this.position);
        }
        return ret.getValue();
    }

    @Override
    public final Object getValue(String name) {
        if (name == null) {
            return null;
        }
        int p = this.columns.getColumnNo(name);
        if (p == -1) {
            return null;
        }
        if (this.newInfo == null) {
            return this.columns.list[p].get(this.position);
        }
        NOChild<Object> ret = this.newInfo.getChild(p);
        if (ret == null) {
            return this.columns.list[p].get(this.position);
        }
        return ret.getValue();
    }

    @Override
    public final Object get(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof String) {
            return this.getValue((String)o);
        }
        if (o instanceof Number) {
            return this.getValue(((Number)o).intValue());
        }
        if (ConvertUtil.isNumeric(o)) {
            return this.getValue(ConvertUtil.convertInt(o));
        }
        return this.getValue(ConvertUtil.convertString(o));
    }

    @Override
    public final Boolean getBoolean(int no) {
        return ConvertUtil.convertBool(this.getValue(no));
    }

    @Override
    public final Integer getInt(int no) {
        return ConvertUtil.convertInt(this.getValue(no));
    }

    @Override
    public final Long getLong(int no) {
        return ConvertUtil.convertLong(this.getValue(no));
    }

    @Override
    public final Float getFloat(int no) {
        return ConvertUtil.convertFloat(this.getValue(no));
    }

    @Override
    public final Double getDouble(int no) {
        return ConvertUtil.convertDouble(this.getValue(no));
    }

    @Override
    public final String getString(int no) {
        return ConvertUtil.convertString(this.getValue(no));
    }

    @Override
    public final Date getDate(int no) {
        return ConvertUtil.convertSqlDate(this.getValue(no));
    }

    @Override
    public final Time getTime(int no) {
        return ConvertUtil.convertSqlTime(this.getValue(no));
    }

    @Override
    public final Timestamp getTimestamp(int no) {
        return ConvertUtil.convertSqlTimestamp(this.getValue(no));
    }

    @Override
    public final Boolean getBoolean(long no) {
        return ConvertUtil.convertBool(this.getValue(no));
    }

    @Override
    public final Integer getInt(long no) {
        return ConvertUtil.convertInt(this.getValue(no));
    }

    @Override
    public final Long getLong(long no) {
        return ConvertUtil.convertLong(this.getValue(no));
    }

    @Override
    public final Float getFloat(long no) {
        return ConvertUtil.convertFloat(this.getValue(no));
    }

    @Override
    public final Double getDouble(long no) {
        return ConvertUtil.convertDouble(this.getValue(no));
    }

    @Override
    public final String getString(long no) {
        return ConvertUtil.convertString(this.getValue(no));
    }

    @Override
    public final Date getDate(long no) {
        return ConvertUtil.convertSqlDate(this.getValue(no));
    }

    @Override
    public final Time getTime(long no) {
        return ConvertUtil.convertSqlTime(this.getValue(no));
    }

    @Override
    public final Timestamp getTimestamp(long no) {
        return ConvertUtil.convertSqlTimestamp(this.getValue(no));
    }

    @Override
    public final Boolean getBoolean(String key) {
        return ConvertUtil.convertBool(this.getValue(key));
    }

    @Override
    public final Integer getInt(String key) {
        return ConvertUtil.convertInt(this.getValue(key));
    }

    @Override
    public final Long getLong(String key) {
        return ConvertUtil.convertLong(this.getValue(key));
    }

    @Override
    public final Float getFloat(String key) {
        return ConvertUtil.convertFloat(this.getValue(key));
    }

    @Override
    public final Double getDouble(String key) {
        return ConvertUtil.convertDouble(this.getValue(key));
    }

    @Override
    public final String getString(String key) {
        return ConvertUtil.convertString(this.getValue(key));
    }

    @Override
    public final Date getDate(String key) {
        return ConvertUtil.convertSqlDate(this.getValue(key));
    }

    @Override
    public final Time getTime(String key) {
        return ConvertUtil.convertSqlTime(this.getValue(key));
    }

    @Override
    public final Timestamp getTimestamp(String key) {
        return ConvertUtil.convertSqlTimestamp(this.getValue(key));
    }

    @Override
    public final int getPoint(int x, int y) {
        if (this.positionColumns == null) {
            throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        if (this.newInfo == null) {
            return PositionIndex.getLine(x, y, (Integer)this.columns.list[this.positionColumns[0]].get(this.position), (Integer)this.columns.list[this.positionColumns[1]].get(this.position));
        }
        NOChild<Object> nx = this.newInfo.getChild(this.positionColumns[0]);
        Object xx = nx == null ? this.columns.list[this.positionColumns[0]].get(this.position) : nx.getValue();
        NOChild<Object> ny = this.newInfo.getChild(this.positionColumns[1]);
        Object yy = ny == null ? this.columns.list[this.positionColumns[1]].get(this.position) : ny.getValue();
        return PositionIndex.getLine(x, y, ConvertUtil.convertInt(xx), ConvertUtil.convertInt(yy));
    }

    @Override
    public final int getPoint(Number lat, Number lon) {
        if (this.positionColumns == null) {
            throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u306f\u5229\u7528\u3067\u304d\u307e\u305b\u3093");
        }
        int x = lat instanceof Double || lat instanceof Float || lat instanceof BigDecimal ? PositionIndex.getLat(lat.doubleValue()) : lat.intValue();
        int y = lon instanceof Double || lon instanceof Float || lat instanceof BigDecimal ? PositionIndex.getLon(lon.doubleValue()) : lon.intValue();
        return this.getPoint(x, y);
    }

    @Override
    public final void putAll(Map toMerge) {
        for (Object n : toMerge.keySet()) {
            this.put(n, toMerge.get(n));
        }
    }

    @Override
    public final boolean containsValue(Object value) {
        int len = this.columns.length;
        if (value == null) {
            int i = 0;
            while (i < len) {
                if (this.getValue(i) == null) {
                    return true;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < len) {
                if (value.equals(this.getValue(i))) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    @Override
    public final Set entrySet() {
        return null;
    }

    @Override
    public final Collection values() {
        int len = this.columns.length;
        ArrayList<Object> ret = new ArrayList<Object>();
        int i = 0;
        while (i < len) {
            ret.add(this.getValue(i));
            ++i;
        }
        return ret;
    }

    @Override
    public final Object put(Object name, Object value) {
        int p = this.columns.getColumnNo(ConvertUtil.convertString(name));
        if (p == -1) {
            return null;
        }
        if (this.newInfo == null) {
            this.newInfo = new NOKeyValue(this.columns.length);
        }
        return this.newInfo.put(p, value);
    }

    @Override
    public final boolean containsKey(Object key) {
        if (key instanceof String) {
            return this.columns.getColumnNo((String)key) != -1;
        }
        if (key instanceof Number) {
            int n = ((Number)key).intValue();
            return n >= 0 && n < this.columns.length;
        }
        return false;
    }

    @Override
    public final Object remove(Object key) {
        return this.put(key, (Object)null);
    }

    @Override
    public final boolean isEmpty() {
        return false;
    }

    @Override
    public final Set keySet() {
        HashSet<Object> ret = new HashSet<Object>();
        this.getAllKey(ret);
        return ret;
    }

    @Override
    public int size() {
        return this.columns.length;
    }

    public final void getAllKey(Set<Object> set) {
        int len = this.columns.length;
        String[] names = this.columns.columnNames;
        int i = 0;
        while (i < len) {
            set.add(names[i]);
            ++i;
        }
    }

    public final void getAllValues(Set<Object> set) {
        int len = this.columns.length;
        int i = 0;
        while (i < len) {
            set.add(this.getValue(i));
            ++i;
        }
    }

    public final String toString() {
        int len = this.columns.length;
        String[] names = this.columns.columnNames;
        StringBuilder buf = new StringBuilder();
        buf.append("{");
        int i = 0;
        while (i < len) {
            Object v;
            if (i != 0) {
                buf.append(",");
            }
            if ((v = this.getValue(i)) instanceof String) {
                buf.append(names[i]).append(":\"").append(v).append("\"");
            } else {
                buf.append(names[i]).append(":").append(v);
            }
            ++i;
        }
        return buf.append("}").toString();
    }
}

