/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.table;

import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.table.ColumnName;
import org.maachang.rimdb.table.array.ColumnArray;

public final class Columns {
    protected final ColumnArray[] list;
    protected final int[] types;
    protected final ColumnName[] columns;
    protected final String[] columnNames;
    protected final int length;

    public Columns(ColumnArray[] list, int[] types, ColumnName[] columns) {
        int len = list.length;
        String[] columnNames = new String[len];
        int i = 0;
        while (i < len) {
            columnNames[columns[i].no] = columns[i].name;
            ++i;
        }
        this.list = list;
        this.columns = columns;
        this.types = types;
        this.columnNames = columnNames;
        this.length = list.length;
    }

    public final int getColumnNo(String name) {
        int p = IndexUtil.search(this.columns, (Comparable)((Object)name));
        if (p == -1) {
            return -1;
        }
        return this.columns[p].no;
    }

    public final int length() {
        return this.length;
    }

    public final String getColumnName(int no) {
        return this.columnNames[no];
    }

    public final int getType(int no) {
        return this.types[no];
    }

    public final int getType(String name) {
        int p = this.getColumnNo(name);
        if (p != -1) {
            return this.types[p];
        }
        return -1;
    }

    public ColumnArray getColumnArray(int no) {
        return this.list[no];
    }

    public ColumnArray getColumnArray(String name) {
        int p = this.getColumnNo(name);
        if (p != -1) {
            return this.list[p];
        }
        return null;
    }
}

