/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.search;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.Search;
import org.maachang.rimdb.SearchResult;
import org.maachang.rimdb.TableFactory;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.index.MaskFlags;
import org.maachang.rimdb.index.Pointer;
import org.maachang.rimdb.index.ResultRadixSort;
import org.maachang.rimdb.index.ResultSort;
import org.maachang.rimdb.index.SearchPointer;
import org.maachang.rimdb.index.SortComparable;
import org.maachang.rimdb.index.position.PositionIndexPointer;
import org.maachang.rimdb.search.Block;
import org.maachang.rimdb.search.PointerBlock;
import org.maachang.rimdb.search.PointerList;
import org.maachang.rimdb.search.PositionBlock;
import org.maachang.rimdb.search.SearchBlock;
import org.maachang.rimdb.search.SearchResultImpl;
import org.maachang.rimdb.table.Indexs;
import org.maachang.rimdb.table.TableImpl;
import org.maachang.rimdb.util.NAdd;
import org.maachang.rimdb.util.NArray;

public final class SearchImpl
implements Search {
    private String name;
    private Object[] blockList;
    private Pointer[] parameterList;
    private boolean[] sortDescList;
    private String[] sortColumnList;
    private boolean andOnly;
    private Pointer oneSearchPointer;
    private PositionIndexPointer lastPositionPointer;
    private TableImpl nowTable;

    protected SearchImpl() {
    }

    protected SearchImpl(String name, Object[] blockList, Pointer[] parameterList, Object[] sortList, boolean andOnly, Pointer oneSearchPointer, PositionIndexPointer lastPositionPointer) {
        this.name = name;
        this.blockList = blockList;
        this.parameterList = parameterList;
        this.andOnly = andOnly;
        this.oneSearchPointer = oneSearchPointer;
        this.lastPositionPointer = lastPositionPointer;
        int len = sortList.length;
        if (len == 0) {
            this.sortDescList = new boolean[0];
            this.sortColumnList = new String[0];
        } else {
            this.sortDescList = new boolean[len];
            this.sortColumnList = new String[len];
            int i = 0;
            while (i < len) {
                Object[] o = (Object[])sortList[i];
                this.sortDescList[i] = (Boolean)o[0];
                this.sortColumnList[i] = o.length == 2 ? (String)o[1] : null;
                ++i;
            }
        }
    }

    @Override
    public final void clear() {
        int len = this.parameterList.length;
        int i = 0;
        while (i < len) {
            this.parameterList[i].reset(true);
            ++i;
        }
        this.nowTable = null;
    }

    @Override
    public final String getName() {
        return this.name;
    }

    @Override
    public final int getParameterSize() {
        return this.parameterList.length;
    }

    @Override
    public final SearchImpl setParameter(int no, Object ... value) {
        if (no < 0 || no >= this.parameterList.length) {
            throw new RimDbException("\u6307\u5b9a\u756a\u53f7\u306f\u3001\u30d1\u30e9\u30e1\u30fc\u30bf\u306e\u7bc4\u56f2\u5916\u3067\u3059:" + no);
        }
        if (value.length == 1) {
            this.parameterList[no].parameter(value[0]);
        } else {
            this.parameterList[no].parameter(value);
        }
        return this;
    }

    @Override
    public final int count() {
        return this.count(true);
    }

    @Override
    public final int count(boolean clearMode) {
        TableImpl table = this.getTable();
        if (table.length() == 0) {
            if (clearMode) {
                this.clear();
            }
            return 0;
        }
        if (this.blockList.length == 0) {
            int ret = this.oneSearchPointer != null ? SearchImpl._searchOneCount(table, this.oneSearchPointer) : table.length();
            if (clearMode) {
                this.clear();
            }
            return ret;
        }
        MaskFlags res = SearchImpl._searchBlock(table, this.blockList, this.andOnly);
        if (clearMode) {
            this.clear();
        }
        if (res == null) {
            return 0;
        }
        return res.size();
    }

    @Override
    public final SearchResult execute(int offset, int limit) {
        return this.execute().setDefine(offset, limit);
    }

    @Override
    public final SearchResultImpl execute() {
        TableImpl table = this.getTable();
        if (table.length() == 0) {
            this.clear();
            return new SearchResultImpl(table, null, 0);
        }
        NAdd list = null;
        if (this.blockList.length == 0) {
            if (this.oneSearchPointer != null) {
                list = SearchImpl._searchOneLine(table, this.oneSearchPointer);
            } else {
                if (this.sortColumnList.length == 0) {
                    this.clear();
                    return new SearchResultImpl(table, null, -1);
                }
                list = new NArray(table.length());
                int len = table.length();
                int i = 0;
                while (i < len) {
                    list.add(i);
                    ++i;
                }
            }
        } else {
            MaskFlags res = SearchImpl._searchBlock(table, this.blockList, this.andOnly);
            if (res == null) {
                this.clear();
                return new SearchResultImpl(table, null, 0);
            }
            list = new NArray(res.size());
            res.get(list);
        }
        if (this.sortColumnList.length == 0 || list.size() < 2) {
            this.clear();
            return new SearchResultImpl(table, list.toArray(), list.size());
        }
        int[] array = SearchImpl.sortRow(list.toArray(), list.size(), table, this.sortDescList, this.sortColumnList, this.lastPositionPointer);
        this.clear();
        return new SearchResultImpl(table, array, list.size());
    }

    public final SearchImpl copy() {
        int no;
        SearchImpl ret = new SearchImpl();
        ret.name = this.name;
        ret.sortDescList = this.sortDescList;
        ret.sortColumnList = this.sortColumnList;
        ret.andOnly = this.andOnly;
        int len = this.blockList.length;
        Object[] blist = new Object[len];
        Pointer[] pms = new Pointer[this.parameterList.length];
        ret.blockList = blist;
        ret.parameterList = pms;
        int i = 0;
        while (i < len) {
            Object o = this.blockList[i];
            if (o instanceof Integer) {
                blist[i] = o;
            } else {
                Block b = (Block)o;
                int type = b.getType();
                switch (type) {
                    case 0: 
                    case 1: {
                        Pointer p = (Pointer)b.get();
                        no = p.getNo();
                        if (no != -1) {
                            pms[no] = p = p.copy(true);
                        } else {
                            p = p.copy(false);
                        }
                        blist[i] = new PointerBlock(type, p);
                        break;
                    }
                    case 2: 
                    case 3: {
                        Pointer p;
                        Pointer[] pp = (Pointer[])b.get();
                        int lenJ = pp.length;
                        SearchPointer[] np = new SearchPointer[lenJ];
                        int j = 0;
                        while (j < lenJ) {
                            p = pp[j];
                            no = p.getNo();
                            if (no != -1) {
                                p = p.copy(true);
                                pms[no] = (SearchPointer)p;
                            } else {
                                p = p.copy(false);
                            }
                            np[j] = (SearchPointer)p;
                            ++j;
                        }
                        blist[i] = new PointerList(type, np);
                        break;
                    }
                    case 4: 
                    case 5: {
                        Pointer p = (Pointer)b.get();
                        boolean flg = p == this.lastPositionPointer;
                        no = p.getNo();
                        if (no != -1) {
                            pms[no] = p = p.copy(true);
                        } else {
                            p = p.copy(false);
                        }
                        if (flg) {
                            ret.lastPositionPointer = (PositionIndexPointer)p;
                        }
                        blist[i] = new PositionBlock(type, p);
                    }
                }
            }
            ++i;
        }
        if (this.oneSearchPointer != null) {
            no = this.oneSearchPointer.getNo();
            if (no != -1) {
                pms[no] = ret.oneSearchPointer = this.oneSearchPointer.copy(true);
            } else {
                ret.oneSearchPointer = this.oneSearchPointer.copy(false);
            }
            if (this.oneSearchPointer == this.lastPositionPointer) {
                ret.lastPositionPointer = (PositionIndexPointer)ret.oneSearchPointer;
            }
        }
        return ret;
    }

    protected final TableImpl getTable() {
        if (this.nowTable == null) {
            this.nowTable = (TableImpl)TableFactory.getInstance().get(this.name);
        }
        return this.nowTable;
    }

    private static final MaskFlags _searchBlock(TableImpl table, Object[] list, boolean andOnly) {
        MaskFlags mn = null;
        MaskFlags mb = null;
        int rowLen = table.length();
        int len = list.length;
        Indexs indexTable = table.getIndexs();
        int code = 0;
        int i = 0;
        while (i < len) {
            Object n = list[i];
            if (n instanceof Integer) {
                code = (Integer)n;
            } else {
                Block b = (Block)n;
                int type = b.getType();
                switch (type) {
                    case 0: 
                    case 1: {
                        code = type;
                        mn = new MaskFlags(rowLen);
                        SearchPointer sp = (SearchPointer)b.get();
                        Index idx = indexTable.getIndex(sp.getColumnName());
                        sp.search(idx);
                        SearchBlock.or(mn, idx, (SearchPointer<Index>)sp);
                        break;
                    }
                    case 2: {
                        mn = new MaskFlags(rowLen);
                        SearchPointer[] spList = (SearchPointer[])b.get();
                        int lenJ = spList.length;
                        int j = 0;
                        while (j < lenJ) {
                            spList[j].search(indexTable);
                            ++j;
                        }
                        SearchBlock.andBlock(mn, indexTable, spList);
                        break;
                    }
                    case 3: {
                        mn = new MaskFlags(rowLen);
                        SearchPointer[] spList = (SearchPointer[])b.get();
                        int lenJ = spList.length;
                        int j = 0;
                        while (j < lenJ) {
                            spList[j].search(indexTable);
                            ++j;
                        }
                        SearchBlock.orBlock(mn, indexTable, spList);
                        break;
                    }
                    case 4: {
                        mn = new MaskFlags(rowLen);
                        PositionIndexPointer pp = (PositionIndexPointer)b.get();
                        if (mb != null) {
                            pp.search(mn, mb, indexTable);
                        } else {
                            pp.search(mn, indexTable);
                        }
                        if (andOnly && mn.getListSize() == 0) {
                            return null;
                        }
                        mb = mn;
                        mn = null;
                        break;
                    }
                    case 5: {
                        PositionIndexPointer pp = (PositionIndexPointer)b.get();
                        if (mb == null) {
                            mb = new MaskFlags(rowLen);
                        }
                        pp.search(mb, indexTable);
                        mn = null;
                    }
                }
                if (mn != null) {
                    if (mb == null) {
                        mb = mn;
                    } else if (code == 0) {
                        if (andOnly && mn.getListSize() == 0) {
                            return null;
                        }
                        mb.and(mn);
                    } else {
                        mb.or(mn);
                    }
                    mn = null;
                }
                code = 0;
            }
            ++i;
        }
        return mb;
    }

    private static final NAdd _searchOneLine(TableImpl table, Pointer pointer) {
        if (pointer.getType() == 10) {
            MaskFlags f = new MaskFlags(table.length());
            PositionIndexPointer p = (PositionIndexPointer)pointer;
            p.search(f, table.getIndexs());
            NArray n = new NArray(f.size());
            f.get(n);
            return n;
        }
        SearchPointer p = (SearchPointer)pointer;
        Index idx = table.getIndexs().getIndex(p.getColumnName());
        p.search(idx);
        NArray n = new NArray(p.getCount());
        p.get((NAdd)n, idx);
        return n;
    }

    private static final int _searchOneCount(TableImpl table, Pointer pointer) {
        if (pointer.getType() == 10) {
            MaskFlags f = new MaskFlags(table.length());
            PositionIndexPointer p = (PositionIndexPointer)pointer;
            p.search(f, table.getIndexs());
            return f.size();
        }
        SearchPointer p = (SearchPointer)pointer;
        Index idx = table.getIndexs().getIndex(p.getColumnName());
        p.search(idx);
        return p.getCount();
    }

    private static final int[] sortRow(int[] list, int length, TableImpl table, boolean[] sortDescList, String[] sortColumnList, PositionIndexPointer lastPositionPointer) {
        Indexs indexTable = table.getIndexs();
        int len = sortDescList.length;
        if (len == 1 && sortColumnList[0] != null) {
            ResultRadixSort.sort(indexTable.getIndex(sortColumnList[0]).getSortLines(), sortDescList[0], list, length, table.length());
            return list;
        }
        SortComparable[] comparableList = new SortComparable[len];
        int i = 0;
        while (i < len) {
            String name = sortColumnList[i];
            comparableList[i] = name != null ? indexTable.getIndex(name).getSortLines() : lastPositionPointer.getSort(indexTable);
            ++i;
        }
        ResultSort sortList = new ResultSort(list, length, sortDescList, comparableList);
        sortList.sort();
        return list;
    }
}

