/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.search;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Pointer;
import org.maachang.rimdb.index.position.PositionIndexPointer;
import org.maachang.rimdb.search.PointerBlock;
import org.maachang.rimdb.search.PointerList;
import org.maachang.rimdb.search.PositionBlock;
import org.maachang.rimdb.search.SearchImpl;
import org.maachang.rimdb.util.OList;

public final class CreateSearch {
    private static final NoParams NO_PARAMS = new NoParams();
    private static final int AND = 0;
    private static final int OR = 1;
    private static final int BEGIN = 100;
    private static final int END = 101;
    private String name;
    private OList<Object> list;
    private OList<Object> params;
    private OList<Object> sort;

    public CreateSearch() {
    }

    public CreateSearch(String name) {
        this.create(name);
    }

    public void create(String name) {
        this.name = name;
    }

    public final void clear() {
        if (this.list != null) {
            this.list.clear();
        }
        this.list = null;
        if (this.params != null) {
            this.params.clear();
        }
        this.params = null;
        if (this.sort != null) {
            this.sort.clear();
        }
        this.sort = null;
    }

    public final String getName() {
        return this.name;
    }

    public final void and() {
        this._set(0);
    }

    public final void or() {
        this._set(1);
    }

    public final void begin() {
        this._set(100);
    }

    public final void end() {
        this._set(101);
    }

    private final void _set(int n) {
        if (this.list == null) {
            this.list = new OList();
        }
        this.list.add(n);
    }

    public final void pointer(Pointer pointer) {
        this._pointer(pointer, NO_PARAMS);
    }

    public final void pointer(Pointer pointer, Object ... params) {
        if (params.length > 1) {
            this._pointer(pointer, params);
        } else {
            this._pointer(pointer, params[0]);
        }
    }

    protected final void _pointer(Pointer pointer, Object param) {
        if (pointer == null) {
            throw new RimDbException("[" + this.name + "]\u691c\u7d22\u30dd\u30a4\u30f3\u30bf\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.list == null) {
            this.list = new OList();
        }
        this.list.add(pointer);
        if (this.params == null) {
            this.params = new OList();
        }
        this.params.add(param);
    }

    public final void position(Pointer p) {
        this.position(p, NO_PARAMS);
    }

    public final void position(Pointer p, int x, int y, int half) {
        this.position(p, new int[]{x, y, half});
    }

    protected final void position(Pointer p, Object o) {
        if (p == null) {
            throw new RimDbException("[" + this.name + "]\u691c\u7d22\u30dd\u30a4\u30f3\u30bf\u304c\u8a2d\u5b9a\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
        }
        if (this.list == null) {
            this.list = new OList();
        }
        this.list.add(p);
        if (this.params == null) {
            this.params = new OList();
        }
        this.params.add(o);
    }

    public final void sort(boolean desc, String name) {
        if (this.sort == null) {
            this.sort = new OList();
        }
        this.sort.add(new Object[]{desc, name});
    }

    public final void sort(boolean desc) {
        if (this.sort == null) {
            this.sort = new OList();
        }
        this.sort.add(new Object[]{desc});
    }

    public final SearchImpl create() {
        SearchImpl ret;
        Object[] sort = this.sortList();
        if (this.list == null) {
            ret = new SearchImpl(this.name, new Object[0], new Pointer[0], sort, true, null, null);
        } else {
            int len = this.list.size();
            if (len == 1) {
                if (this.list.get(0) instanceof Pointer) {
                    Pointer[] ps;
                    Pointer p = (Pointer)this.list.get(0);
                    Object pms = this.params.get(0);
                    if (pms == NO_PARAMS) {
                        p.setNo(0);
                        ps = new Pointer[]{p};
                    } else {
                        p.parameter(pms);
                        ps = new Pointer[]{};
                    }
                    ret = p.getType() == 10 ? new SearchImpl(this.name, new Object[0], ps, sort, true, p, (PositionIndexPointer)p) : new SearchImpl(this.name, new Object[0], ps, sort, true, p, null);
                } else {
                    ret = new SearchImpl(this.name, new Object[0], new Pointer[0], sort, true, null, null);
                }
            } else {
                OList<Pointer> prepared = new OList<Pointer>();
                OList<Object> out = new OList<Object>();
                int[] nArray = new int[3];
                nArray[2] = -1;
                int[] cnt = nArray;
                int res = this.toBlock(out, 0, len, prepared, cnt);
                if (len != res) {
                    throw new RimDbException("[" + this.name + "]\u4e0d\u660e\u306aEOF\u3092\u691c\u51fa\u3057\u307e\u3057\u305f");
                }
                len = prepared.size();
                Pointer[] ps = new Pointer[len];
                System.arraycopy(prepared.toArray(), 0, ps, 0, len);
                if (cnt[2] != -1) {
                    PositionIndexPointer pip = (PositionIndexPointer)this.list.get(cnt[2]);
                    ret = new SearchImpl(this.name, out.getArray(), ps, sort, cnt[1] == 0, null, pip);
                } else {
                    ret = new SearchImpl(this.name, out.getArray(), ps, sort, cnt[1] == 0, null, null);
                }
            }
        }
        this.clear();
        return ret;
    }

    private final int toBlock(OList<Object> out, int i, int len, OList<Pointer> prepared, int[] cnt) {
        Object n;
        OList<Pointer> and = new OList<Pointer>();
        OList<Pointer> or = new OList<Pointer>();
        int code = i + 1 < len && (n = this.list.get(i + 1)) instanceof Integer && (Integer)n == 1 ? 1 : 0;
        while (i < len) {
            block15: {
                block14: {
                    n = this.list.get(i);
                    if (!(n instanceof Integer)) break block14;
                    switch ((Integer)n) {
                        case 0: {
                            code = 0;
                            break;
                        }
                        case 1: {
                            code = 1;
                            break;
                        }
                        case 100: {
                            i = this.toBlock(out, i + 1, len, prepared, cnt);
                            if (i != 0) {
                                if (code == 1) {
                                    cnt[1] = cnt[1] + 1;
                                }
                                out.add(code);
                                break;
                            }
                            break block15;
                        }
                        case 101: {
                            CreateSearch.createBlock(out, and, or);
                            return i;
                        }
                    }
                    break block15;
                }
                Pointer p = (Pointer)n;
                n = this.params.get(cnt[0]);
                if (n == NO_PARAMS) {
                    p.setNo(cnt[0]);
                    prepared.add(p);
                } else {
                    p.parameter(n);
                }
                cnt[0] = cnt[0] + 1;
                if (code == 0) {
                    and.add(p);
                } else {
                    cnt[1] = cnt[1] + 1;
                    or.add(p);
                }
                if (p.getType() == 10) {
                    cnt[2] = i;
                }
                code = 0;
            }
            ++i;
        }
        CreateSearch.createBlock(out, and, or);
        return i;
    }

    private static final void createBlock(OList<Object> out, OList<Pointer> and, OList<Pointer> or) {
        int i;
        Pointer p;
        int len;
        if (and.size() > 0) {
            len = and.size();
            if (len == 1) {
                p = and.get(0);
                if (p.getType() == 10) {
                    out.add(new PositionBlock(4, p));
                } else {
                    out.add(new PointerBlock(0, p));
                }
            } else {
                i = 0;
                while (i < len) {
                    p = and.get(i);
                    if (p.getType() == 10) {
                        out.add(new PositionBlock(4, p));
                        and.remove(i);
                        --i;
                        --len;
                    }
                    ++i;
                }
                if (len > 0) {
                    if (len == 1) {
                        out.add(new PointerBlock(0, and.get(0)));
                    } else {
                        out.add(new PointerList(2, and));
                    }
                }
            }
        }
        if (or.size() > 0) {
            len = or.size();
            if (len == 1) {
                p = or.get(0);
                if (p.getType() == 10) {
                    out.add(new PositionBlock(5, p));
                } else {
                    out.add(new PointerBlock(1, p));
                }
            } else {
                i = 0;
                while (i < len) {
                    p = or.get(i);
                    if (p.getType() == 10) {
                        out.add(new PositionBlock(5, p));
                        or.remove(i);
                        --i;
                        --len;
                    }
                    ++i;
                }
                if (len > 0) {
                    if (len == 1) {
                        out.add(new PointerBlock(1, or.get(0)));
                    } else {
                        out.add(new PointerList(3, or));
                    }
                }
            }
        }
    }

    private final Object[] sortList() {
        if (this.sort == null || this.sort.size() == 0) {
            return new Object[0];
        }
        Object[] ret = this.sort.getArray();
        boolean positionFlag = false;
        int len = ret.length;
        int i = 0;
        while (i < len) {
            if (((Object[])ret[i]).length == 1) {
                positionFlag = true;
                break;
            }
            ++i;
        }
        if (positionFlag) {
            len = this.list.size();
            i = 0;
            while (i < len) {
                if (this.list.get(i) instanceof PositionIndexPointer) {
                    return ret;
                }
                ++i;
            }
            throw new RimDbException("[" + this.name + "]\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u30bd\u30fc\u30c8\u306b\u5bfe\u3057\u3066\u3001\u691c\u7d22\u6761\u4ef6\u306b\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u691c\u7d22\u304c" + "\u5b58\u5728\u3057\u306a\u3044\u5834\u5408\u306f\u3001\u51e6\u7406\u3067\u304d\u307e\u305b\u3093");
        }
        return ret;
    }

    private static final class NoParams {
        private NoParams() {
        }
    }
}

