/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index.string;

public final class IString
implements Comparable<IString> {
    protected final char[] value;
    protected final int length;

    public IString() {
        this.value = new char[0];
        this.length = 0;
    }

    public IString(char[] v) {
        if (v == null) {
            this.value = new char[0];
            this.length = 0;
        } else {
            this.value = v;
            this.length = v.length;
        }
    }

    public IString(String v) {
        if (v == null || v.length() == 0) {
            this.value = new char[0];
            this.length = 0;
        } else {
            int len = v.length();
            char[] vv = new char[len];
            int i = 0;
            while (i < len) {
                vv[i] = v.charAt(i);
                ++i;
            }
            this.value = vv;
            this.length = len;
        }
    }

    public final boolean isEmpty() {
        return this.length == 0;
    }

    public final boolean equals(Object o) {
        String oo;
        if (o == this) {
            return true;
        }
        if (o instanceof IString) {
            IString oo2 = (IString)o;
            if (oo2.length == this.length && oo2.value[0] == this.value[0]) {
                int i = 0;
                int len = this.length;
                char[] ooo = oo2.value;
                char[] v = this.value;
                while (++i < len && ooo[i] == v[i]) {
                }
                return i == len;
            }
        } else if (o instanceof String && (oo = (String)o).length() == this.length && oo.charAt(0) == this.value[0]) {
            int i = 0;
            int len = this.length;
            char[] v = this.value;
            while (++i < len && oo.charAt(i) == v[i]) {
            }
            return i == len;
        }
        return false;
    }

    public final boolean equals(int off, IString o, int oOff, int len) {
        if (o.value[oOff] == this.value[off]) {
            int i = 0;
            char[] oval = o.value;
            char[] v = this.value;
            while (++i < len && oval[oOff + i] == v[off + i]) {
            }
            return i == len;
        }
        return false;
    }

    @Override
    public final int compareTo(IString n) {
        int len;
        if (n == this) {
            return 0;
        }
        int n2 = len = this.length < n.length ? this.length : n.length;
        if (n.value[0] == this.value[0]) {
            int i = 0;
            char[] ooo = n.value;
            char[] v = this.value;
            while (++i < len && ooo[i] == v[i]) {
            }
            return i == len ? this.length - n.length : v[i] - ooo[i];
        }
        return this.value[0] - n.value[0];
    }

    public final int toBig(IString n) {
        int len;
        if (n == this) {
            return 0;
        }
        int n2 = len = this.length < n.length ? this.length : n.length;
        if (n.value[0] == this.value[0]) {
            int i = 0;
            char[] ooo = n.value;
            char[] v = this.value;
            while (++i < len && ooo[i] == v[i]) {
            }
            return i == len ? 0 : v[i] - ooo[i];
        }
        return this.value[0] - n.value[0];
    }

    public final int indexOf(String n, int off) {
        int len = n.length();
        if (len == 0 || off + len > this.length) {
            return -1;
        }
        if (len == 1) {
            char[] v = this.value;
            char nn = n.charAt(0);
            int vLen = this.length;
            int i = off;
            while (i < vLen) {
                if (nn != v[i]) {
                    while (++i < vLen && nn != v[i]) {
                    }
                    if (vLen != i) {
                        return i;
                    }
                } else {
                    return i;
                }
                ++i;
            }
        } else {
            char[] v = this.value;
            int vLen = this.length - (len - 1);
            char first = n.charAt(0);
            int i = off;
            while (i < vLen) {
                if (v[i] != first) {
                    while (++i < vLen && v[i] != first) {
                    }
                }
                if (i < vLen) {
                    int next = i + len;
                    int j = i + 1;
                    int k = 1;
                    while (j < next && v[j] == n.charAt(k)) {
                        ++j;
                        ++k;
                    }
                    if (j == next) {
                        return i;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    public final int indexOf(char[] n, int off) {
        int len = n.length;
        if (len == 0 || off + len > this.length) {
            return -1;
        }
        if (len == 1) {
            char[] v = this.value;
            char nn = n[0];
            int vLen = this.length;
            int i = off;
            while (i < vLen) {
                if (nn != v[i]) {
                    while (++i < vLen && nn != v[i]) {
                    }
                    if (vLen != i) {
                        return i;
                    }
                } else {
                    return i;
                }
                ++i;
            }
        } else {
            char[] v = this.value;
            int vLen = this.length - (len - 1);
            char first = n[0];
            int i = off;
            while (i < vLen) {
                if (first != v[i]) {
                    while (++i < vLen && v[i] != first) {
                    }
                }
                if (i < vLen) {
                    int next = i + len;
                    int j = i + 1;
                    int k = 1;
                    while (j < next && v[j] == n[k]) {
                        ++j;
                        ++k;
                    }
                    if (j == next) {
                        return i;
                    }
                }
                ++i;
            }
        }
        return -1;
    }

    public final int indexOf(IString n, int off) {
        if (n.isEmpty()) {
            return -1;
        }
        return this.indexOf(n.value, off);
    }

    public final boolean startsWith(String n) {
        if (n.length() > this.length) {
            return false;
        }
        if (n.charAt(0) == this.value[0]) {
            int i = 0;
            int len = n.length();
            char[] v = this.value;
            while (++i < len && n.charAt(i) == v[i]) {
            }
            return i == len;
        }
        return false;
    }

    public final boolean startsWith(char[] n) {
        if (n.length > this.length) {
            return false;
        }
        if (n[0] == this.value[0]) {
            int i = 0;
            int len = n.length;
            char[] v = this.value;
            while (++i < len && n[i] == v[i]) {
            }
            return i == len;
        }
        return false;
    }

    public final boolean startsWith(IString n) {
        if (n.isEmpty()) {
            return false;
        }
        return this.startsWith(n.value);
    }

    public final boolean endsWith(String n) {
        if (n.length() > this.length) {
            return false;
        }
        int off = this.length - n.length();
        if (n.charAt(0) == this.value[off]) {
            int i = 0;
            int len = this.length - off;
            char[] v = this.value;
            while (++i < len && n.charAt(i) == v[off + i]) {
            }
            return i == len;
        }
        return false;
    }

    public final boolean endsWith(char[] n) {
        if (n.length > this.length) {
            return false;
        }
        int off = this.length - n.length;
        if (n[0] == this.value[off]) {
            int i = 0;
            int len = this.length - off;
            char[] v = this.value;
            while (++i < len && n[i] == v[off + i]) {
            }
            return i == len;
        }
        return false;
    }

    public final boolean endsWith(IString n) {
        if (n.isEmpty()) {
            return false;
        }
        return this.endsWith(n.value);
    }

    public final int length() {
        return this.length;
    }

    public final char[] getChars() {
        return this.value;
    }

    public final String substring(int s, int e) {
        return String.copyValueOf(this.value, s, e - s);
    }

    public final String substring(int s) {
        return String.copyValueOf(this.value, s, this.value.length - s);
    }

    public final IString subIString(int s, int e) {
        int ln = e - s;
        char[] c = new char[ln];
        System.arraycopy(this.value, s, c, 0, ln);
        return new IString(c);
    }

    public final IString subIString(int s) {
        int ln = this.value.length - s;
        char[] c = new char[ln];
        System.arraycopy(this.value, s, c, 0, ln);
        return new IString(c);
    }

    public final String toString() {
        return String.copyValueOf(this.value);
    }
}

