/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index.position;

import java.lang.reflect.Array;
import java.util.List;
import java.util.Map;
import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.index.MaskFlags;
import org.maachang.rimdb.index.position.RadiusSort;
import org.maachang.rimdb.util.ConvertUtil;
import org.maachang.rimdb.util.OList;

public final class PositionIndex {
    protected final int accuracy;
    protected final int[] xIndex;
    protected final int[][] yIndex;
    protected final YLineIndex[][] yLineIndex;
    protected final int[] sortXList;
    protected final int[] sortYList;
    protected static final double _latitudeM = 9.013374140874493E-6;
    public static final double _longitudeM = 1.1003298110363172E-5;

    protected PositionIndex(int accuracy, int[] xList, int[] yList, int[] xIndex, int[][] yIndex, YLineIndex[][] yLineIndex) {
        this.accuracy = accuracy;
        this.xIndex = xIndex;
        this.yIndex = yIndex;
        this.yLineIndex = yLineIndex;
        this.sortXList = xList;
        this.sortYList = yList;
    }

    private final void _search(MaskFlags out, MaskFlags and, int x, int y, int half) {
        if (and != null && and.getListSize() == 0) {
            if (out.getListSize() != 0) {
                out.clear();
            }
            return;
        }
        int posX = x / this.accuracy;
        int posY = y / this.accuracy;
        int halfPos = half / this.accuracy;
        int xPosLeft = posX - halfPos;
        int xPosRight = posX + halfPos;
        int xStartPos = IndexUtil.searchIntBS(true, this.xIndex, xPosLeft);
        int xEndPos = IndexUtil.searchIntBS(false, this.xIndex, xPosRight);
        if (!(this.xIndex[xStartPos] < xPosLeft && this.xIndex[xEndPos] < xPosRight || this.xIndex[xStartPos] > xPosLeft && this.xIndex[xEndPos] > xPosRight)) {
            int yPosLeft = posY - halfPos;
            int yPosRight = posY + halfPos;
            if (and != null) {
                int i = xStartPos;
                while (i <= xEndPos) {
                    int xx = this.xIndex[i];
                    int[] yy = this.yIndex[i];
                    int yStartPos = IndexUtil.searchIntBS(true, yy, yPosLeft);
                    int yEndPos = IndexUtil.searchIntBS(false, yy, yPosRight);
                    if (!(yy[yStartPos] < yPosLeft && yy[yEndPos] < yPosRight || yy[yStartPos] > yPosLeft && yy[yEndPos] > yPosRight)) {
                        YLineIndex[] lm = this.yLineIndex[i];
                        int j = yStartPos;
                        while (j <= yEndPos) {
                            if (PositionIndex.getLine(posX, posY, xx, yy[j]) <= halfPos) {
                                out.orMask(lm[j].yLine, lm[j].yMask);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
                out.and(and);
            } else {
                int i = xStartPos;
                while (i <= xEndPos) {
                    int xx = this.xIndex[i];
                    int[] yy = this.yIndex[i];
                    int yStartPos = IndexUtil.searchIntBS(false, yy, yPosLeft);
                    int yEndPos = IndexUtil.searchIntBS(false, yy, yPosRight);
                    if (!(yy[yStartPos] < yPosLeft && yy[yEndPos] < yPosRight || yy[yStartPos] > yPosLeft && yy[yEndPos] > yPosRight)) {
                        YLineIndex[] lm = this.yLineIndex[i];
                        int j = yStartPos;
                        while (j <= yEndPos) {
                            if (PositionIndex.getLine(posX, posY, xx, yy[j]) <= halfPos) {
                                out.orMask(lm[j].yLine, lm[j].yMask);
                            }
                            ++j;
                        }
                    }
                    ++i;
                }
            }
        }
    }

    protected static final int[] convert(Object word) {
        if (word == null) {
            throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u691c\u7d22\u6761\u4ef6\u306bnull\u306f\u8a2d\u5b9a\u3067\u304d\u307e\u305b\u3093");
        }
        if (word instanceof int[]) {
            int[] n = (int[])word;
            if (n.length < 3) {
                throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u691c\u7d22\u6761\u4ef6\u306f3\u3064\u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059");
            }
            return new int[]{n[0], n[1], n[2]};
        }
        if (word instanceof Integer[]) {
            Integer[] n = (Integer[])word;
            if (n.length < 3) {
                throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u691c\u7d22\u6761\u4ef6\u306f3\u3064\u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059");
            }
            return new int[]{n[0], n[1], n[2]};
        }
        if (word instanceof List) {
            List n = (List)word;
            if (n.size() < 3) {
                throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u691c\u7d22\u6761\u4ef6\u306f3\u3064\u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059");
            }
            return PositionIndex.convertLatLon(n.get(0), n.get(1), n.get(2));
        }
        if (word instanceof Object[]) {
            Object[] n = (Object[])word;
            if (n.length < 3) {
                throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u691c\u7d22\u6761\u4ef6\u306f3\u3064\u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059");
            }
            return PositionIndex.convertLatLon(n[0], n[1], n[2]);
        }
        if (word instanceof OList) {
            OList n = (OList)word;
            if (n.size() < 3) {
                throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u691c\u7d22\u6761\u4ef6\u306f3\u3064\u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059");
            }
            return PositionIndex.convertLatLon(n.get(0), n.get(1), n.get(2));
        }
        if (word instanceof Map) {
            Object h;
            Object y;
            Map n = (Map)word;
            Object x = n.get("x");
            if (x == null || (y = n.get("y")) == null || (h = n.get("half")) == null) {
                throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u691c\u7d22\u6761\u4ef6\u306f3\u3064\u306e\u5b9a\u7fa9[x,y,half]\u304c\u5fc5\u8981\u3067\u3059");
            }
            return PositionIndex.convertLatLon(x, y, h);
        }
        if (word.getClass().isArray()) {
            if (Array.getLength(word) < 3) {
                throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u691c\u7d22\u6761\u4ef6\u306f3\u3064\u306e\u5b9a\u7fa9\u304c\u5fc5\u8981\u3067\u3059");
            }
            return PositionIndex.convertLatLon(Array.get(word, 0), Array.get(word, 1), Array.get(word, 2));
        }
        throw new RimDbException("\u7a7a\u9593\u30a4\u30f3\u30c7\u30c3\u30af\u30b9\u691c\u7d22\u6761\u4ef6\u306b\u306f[" + word.getClass().getName() + "]\u30aa\u30d6\u30b8\u30a7\u30af\u30c8\u306f\u5b9a\u7fa9\u3067\u304d\u307e\u305b\u3093");
    }

    private static final int[] convertLatLon(Object o1, Object o2, Object o3) {
        int a = o1 instanceof Double || o1 instanceof Float ? PositionIndex.getLat(ConvertUtil.convertDouble(o1)) : ConvertUtil.convertInt(o1);
        int b = o2 instanceof Double || o2 instanceof Float ? PositionIndex.getLon(ConvertUtil.convertDouble(o2)) : ConvertUtil.convertInt(o2);
        return new int[]{a, b, ConvertUtil.convertInt(o3)};
    }

    protected final void _search(MaskFlags out, MaskFlags and, Object word) {
        int[] n = PositionIndex.convert(word);
        this._search(out, and, n[0], n[1], n[2]);
    }

    public final void search(MaskFlags out, int x, int y, int half) {
        this._search(out, null, x, y, half);
    }

    public final void search(MaskFlags out, MaskFlags and, int x, int y, int half) {
        this._search(out, and, x, y, half);
    }

    public final void search(MaskFlags out, Object n) {
        this._search(out, null, n);
    }

    public final void search(MaskFlags out, MaskFlags and, Object n) {
        this._search(out, and, n);
    }

    public final RadiusSort getSort(int x, int y) {
        return new RadiusSort(this.sortXList, this.sortYList, x, y);
    }

    public static final int getLine(int ax, int ay, int bx, int by) {
        int dy;
        int dx = ax > bx ? ax - bx : bx - ax;
        if (dx < (dy = ay > by ? ay - by : by - ay)) {
            return (dy << 8) + (dy << 3) - (dy << 4) - (dy << 1) + (dx << 7) - (dx << 5) + (dx << 3) - (dx << 1) >> 8;
        }
        return (dx << 8) + (dx << 3) - (dx << 4) - (dx << 1) + (dy << 7) - (dy << 5) + (dy << 3) - (dy << 1) >> 8;
    }

    public static final int getLat(double lat) {
        return (int)(lat / 9.013374140874493E-6);
    }

    public static final int getLon(double lon) {
        return (int)(lon / 1.1003298110363172E-5);
    }

    protected static final class YLineIndex {
        int[] yLine;
        int[] yMask;

        protected YLineIndex() {
        }
    }
}

