/*
 * Decompiled with CFR 0.152.
 */
package org.maachang.rimdb.index.number32;

import org.maachang.rimdb.RimDbException;
import org.maachang.rimdb.index.Index;
import org.maachang.rimdb.index.IndexUtil;
import org.maachang.rimdb.util.NAdd;

public final class Number32Index
extends Index<Integer> {
    protected final int[] index;

    public Number32Index(int[] index, int[][] line, int max) {
        super(line, max);
        this.index = index;
    }

    public int[] getIndex() {
        return this.index;
    }

    @Override
    public final int eq(Integer key) {
        return IndexUtil.searchInt(this.index, key);
    }

    @Override
    public final int big(boolean eq, Integer key) {
        if (this.index[this.index.length - 1] < key) {
            return -1;
        }
        if (eq) {
            return IndexUtil.searchIntBS(true, this.index, key);
        }
        int n = IndexUtil.searchIntBS(true, this.index, key);
        if (this.index[n] == key && ++n >= this.maxLine) {
            return -1;
        }
        return n;
    }

    @Override
    public final int small(boolean eq, Integer key) {
        if (this.index[0] > key) {
            return -1;
        }
        if (eq) {
            return IndexUtil.searchIntBS(false, this.index, key);
        }
        int n = IndexUtil.searchIntBS(false, this.index, key);
        if (this.index[n] == key && --n < 0) {
            return -1;
        }
        return n;
    }

    @Override
    public final boolean between(int[] out, Integer start, Integer end) {
        if (start > end) {
            Integer n = start;
            start = end;
            end = n;
        }
        out[0] = IndexUtil.searchIntBS(true, this.index, start);
        out[1] = IndexUtil.searchIntBS(false, this.index, end);
        return !(this.index[out[0]] < start && this.index[out[1]] < end || this.index[out[0]] > start && this.index[out[1]] > end);
    }

    @Override
    public final void like(NAdd result, String key) {
        throw new RimDbException("Number32\u3067\u306fLike\u306f\u30b5\u30dd\u30fc\u30c8\u3055\u308c\u3066\u3044\u307e\u305b\u3093");
    }
}

